interface AnnotationQuery {
    builtIn: number;
    datasource: {};
    enable: boolean;
    hide?: boolean;
    iconColor?: string;
    name?: string;
    rawQuery?: string;
    showIn: number;
    target?: {};
    type: string;
}
declare const defaultAnnotationQuery: Partial<AnnotationQuery>;
interface VariableModel {
    label?: string;
    name: string;
    type: VariableType;
}
interface DashboardLink {
    asDropdown: boolean;
    icon?: string;
    includeVars: boolean;
    keepTime: boolean;
    tags: string[];
    targetBlank: boolean;
    title: string;
    tooltip?: string;
    type: DashboardLinkType;
    url?: string;
}
declare const defaultDashboardLink: Partial<DashboardLink>;
declare type DashboardLinkType = ('link' | 'dashboards');
declare type VariableType = ('query' | 'adhoc' | 'constant' | 'datasource' | 'interval' | 'textbox' | 'custom' | 'system');
declare enum FieldColorModeId {
    ContinuousGrYlRd = "continuous-GrYlRd",
    Fixed = "fixed",
    PaletteClassic = "palette-classic",
    PaletteSaturated = "palette-saturated",
    Thresholds = "thresholds"
}
declare type FieldColorSeriesByMode = ('min' | 'max' | 'last');
interface FieldColor {
    fixedColor?: string;
    mode: (FieldColorModeId | string);
    seriesBy?: FieldColorSeriesByMode;
}
interface GridPos {
    h: number;
    static?: boolean;
    w: number;
    x: number;
    y: number;
}
declare const defaultGridPos: Partial<GridPos>;
interface Threshold {
    color: string;
    state?: string;
    value?: number;
}
declare enum ThresholdsMode {
    Absolute = "absolute",
    Percentage = "percentage"
}
interface ThresholdsConfig {
    mode: ThresholdsMode;
    steps: Threshold[];
}
declare const defaultThresholdsConfig: Partial<ThresholdsConfig>;
interface Transformation {
    id: string;
    options: {};
}
declare enum DashboardCursorSync {
    Crosshair = 1,
    Off = 0,
    Tooltip = 2
}
declare const defaultDashboardCursorSync: DashboardCursorSync;
interface Panel {
    datasource?: {};
    description?: string;
    fieldConfig: {
        defaults: {};
        overrides: {
            matcher: {
                id: string;
            };
            properties: {
                id: string;
            }[];
        }[];
    };
    gridPos?: GridPos;
    id?: number;
    interval?: string;
    links?: DashboardLink[];
    maxDataPoints?: number;
    options: {};
    pluginVersion?: string;
    repeat?: string;
    repeatDirection: ('h' | 'v');
    tags?: string[];
    targets?: {}[];
    thresholds?: any[];
    timeFrom?: string;
    timeRegions?: any[];
    timeShift?: string;
    title?: string;
    transformations: Transformation[];
    transparent: boolean;
    type: string;
}
declare const defaultPanel: Partial<Panel>;
interface RowPanel {
    collapsed: boolean;
    datasource?: {};
    gridPos?: GridPos;
    id: number;
    panels: (Panel | {
        type: 'graph';
    } | {
        type: 'heatmap';
    })[];
    repeat?: string;
    title?: string;
    type: 'row';
}
declare const defaultRowPanel: Partial<RowPanel>;
interface Dashboard {
    annotations?: {
        list: AnnotationQuery[];
    };
    description?: string;
    editable: boolean;
    fiscalYearStartMonth?: number;
    gnetId?: string;
    graphTooltip: DashboardCursorSync;
    id?: number;
    links?: DashboardLink[];
    liveNow?: boolean;
    panels?: (Panel | RowPanel | {
        type: 'graph';
    } | {
        type: 'heatmap';
    })[];
    refresh?: (string | false);
    schemaVersion: number;
    style: ('light' | 'dark');
    tags?: string[];
    templating?: {
        list: VariableModel[];
    };
    time?: {
        from: string;
        to: string;
    };
    timepicker?: {
        collapse: boolean;
        enable: boolean;
        hidden: boolean;
        refresh_intervals: string[];
    };
    timezone?: ('browser' | 'utc' | '');
    title?: string;
    uid?: string;
    version?: number;
    weekStart?: string;
}
declare const defaultDashboard: Partial<Dashboard>;
