/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// DistributionsMavenAPIService DistributionsMavenAPI service
type DistributionsMavenAPIService service

type DistributionsMavenAPIDistributionsMavenMavenCreateRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	mavenMavenDistribution *MavenMavenDistribution
}

func (r DistributionsMavenAPIDistributionsMavenMavenCreateRequest) MavenMavenDistribution(mavenMavenDistribution MavenMavenDistribution) DistributionsMavenAPIDistributionsMavenMavenCreateRequest {
	r.mavenMavenDistribution = &mavenMavenDistribution
	return r
}

func (r DistributionsMavenAPIDistributionsMavenMavenCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenCreateExecute(r)
}

/*
DistributionsMavenMavenCreate Create a maven distribution

Trigger an asynchronous create task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsMavenAPIDistributionsMavenMavenCreateRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenCreate(ctx context.Context) DistributionsMavenAPIDistributionsMavenMavenCreateRequest {
	return DistributionsMavenAPIDistributionsMavenMavenCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsMavenAPIService) DistributionsMavenMavenCreateExecute(r DistributionsMavenAPIDistributionsMavenMavenCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/maven/maven/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.mavenMavenDistribution == nil {
		return localVarReturnValue, nil, reportError("mavenMavenDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.mavenMavenDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsMavenAPIDistributionsMavenMavenDeleteRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	mavenMavenDistributionHref string
}

func (r DistributionsMavenAPIDistributionsMavenMavenDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenDeleteExecute(r)
}

/*
DistributionsMavenMavenDelete Delete a maven distribution

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param mavenMavenDistributionHref
 @return DistributionsMavenAPIDistributionsMavenMavenDeleteRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenDelete(ctx context.Context, mavenMavenDistributionHref string) DistributionsMavenAPIDistributionsMavenMavenDeleteRequest {
	return DistributionsMavenAPIDistributionsMavenMavenDeleteRequest{
		ApiService: a,
		ctx: ctx,
		mavenMavenDistributionHref: mavenMavenDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsMavenAPIService) DistributionsMavenMavenDeleteExecute(r DistributionsMavenAPIDistributionsMavenMavenDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{maven_maven_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"maven_maven_distribution_href"+"}", parameterValueToString(r.mavenMavenDistributionHref, "mavenMavenDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsMavenAPIDistributionsMavenMavenListRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	basePath *string
	basePathContains *string
	basePathIcontains *string
	basePathIn *[]string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	repository *string
	repositoryIn *[]string
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where base_path matches value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) BasePath(basePath string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.basePath = &basePath
	return r
}

// Filter results where base_path contains value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) BasePathContains(basePathContains string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.basePathContains = &basePathContains
	return r
}

// Filter results where base_path contains value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) BasePathIcontains(basePathIcontains string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.basePathIcontains = &basePathIcontains
	return r
}

// Filter results where base_path is in a comma-separated list of values
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) BasePathIn(basePathIn []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.basePathIn = &basePathIn
	return r
}

// Number of results to return per page.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Limit(limit int32) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Name(name string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) NameContains(nameContains string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) NameIcontains(nameIcontains string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) NameIn(nameIn []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) NameStartswith(nameStartswith string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Offset(offset int32) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;base_path&#x60; - Base path * &#x60;-base_path&#x60; - Base path (descending) * &#x60;hidden&#x60; - Hidden * &#x60;-hidden&#x60; - Hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Ordering(ordering []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) PulpHrefIn(pulpHrefIn []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) PulpIdIn(pulpIdIn []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) PulpLabelSelect(pulpLabelSelect string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where repository matches value
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Repository(repository string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.repository = &repository
	return r
}

// Filter results where repository is in a comma-separated list of values
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) RepositoryIn(repositoryIn []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.repositoryIn = &repositoryIn
	return r
}

// Filter distributions based on the content served by them
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) WithContent(withContent string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Fields(fields []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) ExcludeFields(excludeFields []string) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsMavenAPIDistributionsMavenMavenListRequest) Execute() (*PaginatedmavenMavenDistributionResponseList, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenListExecute(r)
}

/*
DistributionsMavenMavenList List maven distributions

ViewSet for Maven Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsMavenAPIDistributionsMavenMavenListRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenList(ctx context.Context) DistributionsMavenAPIDistributionsMavenMavenListRequest {
	return DistributionsMavenAPIDistributionsMavenMavenListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedmavenMavenDistributionResponseList
func (a *DistributionsMavenAPIService) DistributionsMavenMavenListExecute(r DistributionsMavenAPIDistributionsMavenMavenListRequest) (*PaginatedmavenMavenDistributionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedmavenMavenDistributionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/maven/maven/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.basePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path", r.basePath, "")
	}
	if r.basePathContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__contains", r.basePathContains, "")
	}
	if r.basePathIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__icontains", r.basePathIcontains, "")
	}
	if r.basePathIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__in", r.basePathIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository__in", r.repositoryIn, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	mavenMavenDistributionHref string
	patchedmavenMavenDistribution *PatchedmavenMavenDistribution
}

func (r DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest) PatchedmavenMavenDistribution(patchedmavenMavenDistribution PatchedmavenMavenDistribution) DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest {
	r.patchedmavenMavenDistribution = &patchedmavenMavenDistribution
	return r
}

func (r DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenPartialUpdateExecute(r)
}

/*
DistributionsMavenMavenPartialUpdate Update a maven distribution

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param mavenMavenDistributionHref
 @return DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenPartialUpdate(ctx context.Context, mavenMavenDistributionHref string) DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest {
	return DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		mavenMavenDistributionHref: mavenMavenDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsMavenAPIService) DistributionsMavenMavenPartialUpdateExecute(r DistributionsMavenAPIDistributionsMavenMavenPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{maven_maven_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"maven_maven_distribution_href"+"}", parameterValueToString(r.mavenMavenDistributionHref, "mavenMavenDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedmavenMavenDistribution == nil {
		return localVarReturnValue, nil, reportError("patchedmavenMavenDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedmavenMavenDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsMavenAPIDistributionsMavenMavenReadRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	mavenMavenDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsMavenAPIDistributionsMavenMavenReadRequest) Fields(fields []string) DistributionsMavenAPIDistributionsMavenMavenReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsMavenAPIDistributionsMavenMavenReadRequest) ExcludeFields(excludeFields []string) DistributionsMavenAPIDistributionsMavenMavenReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsMavenAPIDistributionsMavenMavenReadRequest) Execute() (*MavenMavenDistributionResponse, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenReadExecute(r)
}

/*
DistributionsMavenMavenRead Inspect a maven distribution

ViewSet for Maven Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param mavenMavenDistributionHref
 @return DistributionsMavenAPIDistributionsMavenMavenReadRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenRead(ctx context.Context, mavenMavenDistributionHref string) DistributionsMavenAPIDistributionsMavenMavenReadRequest {
	return DistributionsMavenAPIDistributionsMavenMavenReadRequest{
		ApiService: a,
		ctx: ctx,
		mavenMavenDistributionHref: mavenMavenDistributionHref,
	}
}

// Execute executes the request
//  @return MavenMavenDistributionResponse
func (a *DistributionsMavenAPIService) DistributionsMavenMavenReadExecute(r DistributionsMavenAPIDistributionsMavenMavenReadRequest) (*MavenMavenDistributionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MavenMavenDistributionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{maven_maven_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"maven_maven_distribution_href"+"}", parameterValueToString(r.mavenMavenDistributionHref, "mavenMavenDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsMavenAPIDistributionsMavenMavenUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsMavenAPIService
	mavenMavenDistributionHref string
	mavenMavenDistribution *MavenMavenDistribution
}

func (r DistributionsMavenAPIDistributionsMavenMavenUpdateRequest) MavenMavenDistribution(mavenMavenDistribution MavenMavenDistribution) DistributionsMavenAPIDistributionsMavenMavenUpdateRequest {
	r.mavenMavenDistribution = &mavenMavenDistribution
	return r
}

func (r DistributionsMavenAPIDistributionsMavenMavenUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsMavenMavenUpdateExecute(r)
}

/*
DistributionsMavenMavenUpdate Update a maven distribution

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param mavenMavenDistributionHref
 @return DistributionsMavenAPIDistributionsMavenMavenUpdateRequest
*/
func (a *DistributionsMavenAPIService) DistributionsMavenMavenUpdate(ctx context.Context, mavenMavenDistributionHref string) DistributionsMavenAPIDistributionsMavenMavenUpdateRequest {
	return DistributionsMavenAPIDistributionsMavenMavenUpdateRequest{
		ApiService: a,
		ctx: ctx,
		mavenMavenDistributionHref: mavenMavenDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsMavenAPIService) DistributionsMavenMavenUpdateExecute(r DistributionsMavenAPIDistributionsMavenMavenUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsMavenAPIService.DistributionsMavenMavenUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{maven_maven_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"maven_maven_distribution_href"+"}", parameterValueToString(r.mavenMavenDistributionHref, "mavenMavenDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.mavenMavenDistribution == nil {
		return localVarReturnValue, nil, reportError("mavenMavenDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.mavenMavenDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
