/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RepositorySign type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RepositorySign{}

// RepositorySign Serializer for container images signing.
type RepositorySign struct {
	// A signing service to sign with. This will override a signing service set on the repo.
	ManifestSigningService NullableString `json:"manifest_signing_service,omitempty"`
	// Future base path content will be distributed at for sync repos
	FutureBasePath *string `json:"future_base_path,omitempty"`
	// A list of tags to sign.
	TagsList []interface{} `json:"tags_list,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RepositorySign RepositorySign

// NewRepositorySign instantiates a new RepositorySign object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRepositorySign() *RepositorySign {
	this := RepositorySign{}
	return &this
}

// NewRepositorySignWithDefaults instantiates a new RepositorySign object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRepositorySignWithDefaults() *RepositorySign {
	this := RepositorySign{}
	return &this
}

// GetManifestSigningService returns the ManifestSigningService field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *RepositorySign) GetManifestSigningService() string {
	if o == nil || IsNil(o.ManifestSigningService.Get()) {
		var ret string
		return ret
	}
	return *o.ManifestSigningService.Get()
}

// GetManifestSigningServiceOk returns a tuple with the ManifestSigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RepositorySign) GetManifestSigningServiceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ManifestSigningService.Get(), o.ManifestSigningService.IsSet()
}

// HasManifestSigningService returns a boolean if a field has been set.
func (o *RepositorySign) HasManifestSigningService() bool {
	if o != nil && o.ManifestSigningService.IsSet() {
		return true
	}

	return false
}

// SetManifestSigningService gets a reference to the given NullableString and assigns it to the ManifestSigningService field.
func (o *RepositorySign) SetManifestSigningService(v string) {
	o.ManifestSigningService.Set(&v)
}
// SetManifestSigningServiceNil sets the value for ManifestSigningService to be an explicit nil
func (o *RepositorySign) SetManifestSigningServiceNil() {
	o.ManifestSigningService.Set(nil)
}

// UnsetManifestSigningService ensures that no value is present for ManifestSigningService, not even an explicit nil
func (o *RepositorySign) UnsetManifestSigningService() {
	o.ManifestSigningService.Unset()
}

// GetFutureBasePath returns the FutureBasePath field value if set, zero value otherwise.
func (o *RepositorySign) GetFutureBasePath() string {
	if o == nil || IsNil(o.FutureBasePath) {
		var ret string
		return ret
	}
	return *o.FutureBasePath
}

// GetFutureBasePathOk returns a tuple with the FutureBasePath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RepositorySign) GetFutureBasePathOk() (*string, bool) {
	if o == nil || IsNil(o.FutureBasePath) {
		return nil, false
	}
	return o.FutureBasePath, true
}

// HasFutureBasePath returns a boolean if a field has been set.
func (o *RepositorySign) HasFutureBasePath() bool {
	if o != nil && !IsNil(o.FutureBasePath) {
		return true
	}

	return false
}

// SetFutureBasePath gets a reference to the given string and assigns it to the FutureBasePath field.
func (o *RepositorySign) SetFutureBasePath(v string) {
	o.FutureBasePath = &v
}

// GetTagsList returns the TagsList field value if set, zero value otherwise.
func (o *RepositorySign) GetTagsList() []interface{} {
	if o == nil || IsNil(o.TagsList) {
		var ret []interface{}
		return ret
	}
	return o.TagsList
}

// GetTagsListOk returns a tuple with the TagsList field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RepositorySign) GetTagsListOk() ([]interface{}, bool) {
	if o == nil || IsNil(o.TagsList) {
		return nil, false
	}
	return o.TagsList, true
}

// HasTagsList returns a boolean if a field has been set.
func (o *RepositorySign) HasTagsList() bool {
	if o != nil && !IsNil(o.TagsList) {
		return true
	}

	return false
}

// SetTagsList gets a reference to the given []interface{} and assigns it to the TagsList field.
func (o *RepositorySign) SetTagsList(v []interface{}) {
	o.TagsList = v
}

func (o RepositorySign) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RepositorySign) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if o.ManifestSigningService.IsSet() {
		toSerialize["manifest_signing_service"] = o.ManifestSigningService.Get()
	}
	if !IsNil(o.FutureBasePath) {
		toSerialize["future_base_path"] = o.FutureBasePath
	}
	if !IsNil(o.TagsList) {
		toSerialize["tags_list"] = o.TagsList
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RepositorySign) UnmarshalJSON(bytes []byte) (err error) {
	varRepositorySign := _RepositorySign{}

	if err = json.Unmarshal(bytes, &varRepositorySign); err == nil {
		*o = RepositorySign(varRepositorySign)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "manifest_signing_service")
		delete(additionalProperties, "future_base_path")
		delete(additionalProperties, "tags_list")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRepositorySign struct {
	value *RepositorySign
	isSet bool
}

func (v NullableRepositorySign) Get() *RepositorySign {
	return v.value
}

func (v *NullableRepositorySign) Set(val *RepositorySign) {
	v.value = val
	v.isSet = true
}

func (v NullableRepositorySign) IsSet() bool {
	return v.isSet
}

func (v *NullableRepositorySign) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRepositorySign(val *RepositorySign) *NullableRepositorySign {
	return &NullableRepositorySign{value: val, isSet: true}
}

func (v NullableRepositorySign) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRepositorySign) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


