/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tomcat;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.dogtagpki.tomcat.JSSContext;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.provider.javax.crypto.JSSNativeTrustManager;

public class JSSUtil
extends SSLUtilBase {
    public static Log logger = LogFactory.getLog(JSSUtil.class);
    private String keyAlias;
    private SSLEngine engine;
    private Set<String> protocols;
    private Set<String> ciphers;

    public JSSUtil(SSLHostConfigCertificate cert) {
        super(cert);
        this.keyAlias = this.certificate.getCertificateKeyAlias();
        logger.debug((Object)"JSSUtil: instance created");
    }

    private void init() {
        if (this.engine != null) {
            return;
        }
        try {
            JSSContext ctx = new JSSContext(null);
            ctx.init(null, null, null);
            this.engine = ctx.createSSLEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.protocols = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.engine.getSupportedProtocols())));
        this.ciphers = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.engine.getSupportedCipherSuites())));
    }

    public KeyManager[] getKeyManagers() throws Exception {
        logger.debug((Object)"JSSUtil: getKeyManagers()");
        KeyManagerFactory jkm = KeyManagerFactory.getInstance("NssX509", "Mozilla-JSS");
        return jkm.getKeyManagers();
    }

    public TrustManager[] getTrustManagers() throws Exception {
        logger.debug((Object)"JSSUtil: getTrustManagers()");
        if (!JSSProvider.ENABLE_JSSENGINE) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("NssX509");
            return tmf.getTrustManagers();
        }
        return new TrustManager[]{new JSSNativeTrustManager()};
    }

    public SSLContext createSSLContextInternal(List<String> negotiableProtocols) throws Exception {
        logger.debug((Object)("JSSUtil createSSLContextInternal(...) keyAlias=" + this.keyAlias));
        return new JSSContext(this.keyAlias);
    }

    public boolean isTls13RenegAuthAvailable() {
        logger.debug((Object)"JSSUtil: isTls13RenegAuthAvailable()");
        return true;
    }

    public Log getLog() {
        logger.debug((Object)"JSSUtil: getLog()");
        return logger;
    }

    protected Set<String> getImplementedProtocols() {
        logger.debug((Object)"JSSUtil: getImplementedProtocols()");
        this.init();
        return this.protocols;
    }

    protected Set<String> getImplementedCiphers() {
        logger.debug((Object)"JSSUtil: getImplementedCiphers()");
        this.init();
        return this.ciphers;
    }
}

