/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.SASLOption;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SASLMechanismInfo {
    private final boolean acceptsPassword;
    private final boolean requiresPassword;
    @NotNull
    private final List<SASLOption> options;
    @NotNull
    private final String description;
    @NotNull
    private final String name;

    public SASLMechanismInfo(@NotNull String name, @NotNull String description, boolean acceptsPassword, boolean requiresPassword, SASLOption ... options) {
        this.name = name;
        this.description = description;
        this.acceptsPassword = acceptsPassword;
        this.requiresPassword = requiresPassword;
        this.options = options == null || options.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(options));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public boolean acceptsPassword() {
        return this.acceptsPassword;
    }

    public boolean requiresPassword() {
        return this.requiresPassword;
    }

    @NotNull
    public List<SASLOption> getOptions() {
        return this.options;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SASLMechanismInfo(name='");
        buffer.append(this.name);
        buffer.append("', description='");
        buffer.append(this.description);
        buffer.append("', acceptsPassword=");
        buffer.append(this.acceptsPassword);
        buffer.append(", requiresPassword=");
        buffer.append(this.requiresPassword);
        buffer.append(", options={");
        Iterator<SASLOption> iterator = this.options.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

