/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import com.netscape.cmscore.apps.CMS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.tps.main.TPSBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSPhoneHome
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(TPSPhoneHome.class);
    private static final long serialVersionUID = 1864386666927370987L;
    private static String phoneHomeName = "phoneHome.xml";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("TPSPhoneHome entering.");
        this.renderPhoneHome(request, response);
    }

    private void renderPhoneHome(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream stream = null;
        BufferedInputStream buf = null;
        FileInputStream input = null;
        logger.debug("TPSPhoneHome.renderPhoneHome entering.");
        try {
            stream = response.getOutputStream();
            response.setContentType("application/xml");
            String confPath = this.getConfigPath() + File.separator + phoneHomeName;
            logger.debug("TPSPhoneHome.renderPhoneHome: confPath: " + confPath);
            input = new FileInputStream(confPath);
            buf = new BufferedInputStream(input);
            int readBytes = 0;
            TPSBuffer readData = new TPSBuffer();
            while ((readBytes = buf.read()) != -1) {
                stream.write(readBytes);
                readData.add((byte)readBytes);
            }
            logger.debug("TPSPhoneHome.renderPhoneHome: data: " + readData.toHexString());
        }
        catch (IOException e) {
            logger.error("TPSPhoneHome.renderPhoneHome:  " + e.getMessage(), (Throwable)e);
            throw new ServletException("TPSPhoneHome.renderPhoneHome: Error encountered:  " + e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (buf != null) {
                buf.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    private String getConfigPath() {
        logger.debug("TPSPhoneHome.getConfigPath: entering.");
        String context = this.getServletContext().getContextPath();
        String subsystem = context.startsWith("/") ? context.substring(1) : context;
        String instanceDir = CMS.getInstanceDir();
        logger.debug("TPSPhoneHome.getConfigPath: instanceDir: " + instanceDir);
        String path = instanceDir + File.separator + "conf" + File.separator + subsystem + File.separator;
        logger.debug("TPSPhoneHome.getConfigPath: returning: " + path);
        return path;
    }
}

