/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.profile;

import com.netscape.certsrv.profile.ProfileClient;
import com.netscape.certsrv.profile.ProfileData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.profile.ProfileCLI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileShowCLI.class);
    public ProfileCLI profileCLI;

    public ProfileShowCLI(ProfileCLI profileCLI) {
        super("show", "Show profiles", (CLI)profileCLI);
        this.profileCLI = profileCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option optFilename = new Option(null, "output", true, "Output filename");
        optFilename.setArgName("filename");
        this.options.addOption(optFilename);
        Option optRaw = new Option(null, "raw", false, "Use raw format");
        optRaw.setArgName("raw");
        this.options.addOption(optRaw);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("No Profile ID specified.");
        }
        String profileId = cmdArgs[0];
        String filename = null;
        if (cmd.hasOption("output") && ((filename = cmd.getOptionValue("output")) == null || filename.trim().length() == 0)) {
            throw new Exception("Missing output file name.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ProfileClient profileClient = this.profileCLI.getProfileClient();
        if (cmd.hasOption("raw")) {
            byte[] cfg = profileClient.retrieveProfileRaw(profileId);
            if (filename != null) {
                Files.write(Paths.get(filename, new String[0]), cfg, new OpenOption[0]);
                MainCLI.printMessage("Saved profile " + profileId + " to " + filename);
            } else {
                System.out.write(cfg);
            }
        } else {
            MainCLI.printMessage("Profile \"" + profileId + "\"");
            ProfileData profileData = profileClient.retrieveProfile(profileId);
            if (filename != null) {
                ProfileCLI.saveProfileToFile(filename, profileData);
            } else {
                ProfileCLI.printProfile(profileData);
            }
        }
    }
}

