/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCertCLI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.dogtagpki.nss.NSSExtensionGenerator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCertIssueCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCertIssueCLI.class);

    public NSSCertIssueCLI(NSSCertCLI nssCertCLI) {
        super("issue", "Issue certificate", (CLI)nssCertCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "issuer", true, "Issuer nickname (default is self-signed)");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "csr", true, "Certificate signing request");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "ext", true, "Certificate extensions configuration");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "subjectAltName", true, "Subject alternative name");
        option.setArgName("value");
        this.options.addOption(option);
        option = new Option(null, "serial", true, "Serial number (default is 128-bit random number)");
        option.setArgName("number");
        this.options.addOption(option);
        option = new Option(null, "months-valid", true, "Months valid (default is 3)");
        option.setArgName("months");
        this.options.addOption(option);
        option = new Option(null, "hash", true, "Hash algorithm (default is SHA256)");
        option.setArgName("hash");
        this.options.addOption(option);
        option = new Option(null, "cert", true, "Certificate");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        byte[] bytes;
        X509Certificate issuer;
        String issuerNickname = cmd.getOptionValue("issuer");
        String csrFile = cmd.getOptionValue("csr");
        String extConf = cmd.getOptionValue("ext");
        String subjectAltName = cmd.getOptionValue("subjectAltName");
        String serialNumber = cmd.getOptionValue("serial");
        String monthsValid = cmd.getOptionValue("months-valid", "3");
        String hash = cmd.getOptionValue("hash", "SHA256");
        if (csrFile == null) {
            throw new Exception("Missing certificate signing request");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ClientConfig clientConfig = mainCLI.getConfig();
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        if (issuerNickname == null) {
            issuer = null;
        } else {
            CryptoManager cm = CryptoManager.getInstance();
            issuer = cm.findCertByNickname(issuerNickname);
        }
        String csrPEM = new String(Files.readAllBytes(Paths.get(csrFile, new String[0])));
        byte[] csrBytes = CertUtil.parseCSR((String)csrPEM);
        PKCS10 pkcs10 = new PKCS10(csrBytes);
        NSSExtensionGenerator generator = new NSSExtensionGenerator();
        Extensions extensions = null;
        if (extConf != null) {
            generator.init(extConf);
        }
        if (subjectAltName != null) {
            generator.setParameter("subjectAltName", subjectAltName);
        }
        extensions = generator.createExtensions(issuer, pkcs10);
        String tokenName = clientConfig.getTokenName();
        java.security.cert.X509Certificate cert = nssdb.createCertificate(tokenName, issuer, pkcs10, serialNumber, Integer.valueOf(monthsValid), hash, extensions);
        String format = cmd.getOptionValue("format");
        if (format == null || "PEM".equalsIgnoreCase(format)) {
            bytes = CertUtil.toPEM((java.security.cert.X509Certificate)cert).getBytes();
        } else if ("DER".equalsIgnoreCase(format)) {
            bytes = cert.getEncoded();
        } else {
            throw new Exception("Unsupported format: " + format);
        }
        String filename = cmd.getOptionValue("cert");
        if (filename != null) {
            Files.write(Paths.get(filename, new String[0]), bytes, new OpenOption[0]);
        } else {
            System.out.write(bytes);
        }
    }
}

