/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.certsrv.key.KeyInfoCollection;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyFindCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyFindCLI(KRAKeyCLI keyCLI) {
        super("find", "Find keys", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "clientKeyID", true, "Unique client key identifier");
        option.setArgName("client key ID");
        this.options.addOption(option);
        option = new Option(null, "status", true, "Status: active, inactive");
        option.setArgName("status");
        this.options.addOption(option);
        option = new Option(null, "maxResults", true, "Maximum results");
        option.setArgName("max results");
        this.options.addOption(option);
        option = new Option(null, "maxTime", true, "Maximum time");
        option.setArgName("max time");
        this.options.addOption(option);
        option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
        option = new Option(null, "realm", true, "Realm");
        option.setArgName("realm");
        this.options.addOption(option);
        option = new Option(null, "owner", true, "Owner name");
        option.setArgName("owner");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String clientKeyID = cmd.getOptionValue("clientKeyID");
        String status = cmd.getOptionValue("status");
        String realm = cmd.getOptionValue("realm");
        String ownerName = cmd.getOptionValue("owner");
        String outputFormat = cmd.getOptionValue("output-format", "text");
        String s = cmd.getOptionValue("maxResults");
        Integer maxResults = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("maxTime");
        Integer maxTime = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyClient keyClient = this.keyCLI.getKeyClient();
        KeyInfoCollection keys = keyClient.listKeys(clientKeyID, status, maxResults, maxTime, start, size, realm, ownerName);
        if ("json".equalsIgnoreCase(outputFormat)) {
            System.out.println(keys.toJSON());
        } else if ("text".equalsIgnoreCase(outputFormat)) {
            Collection entries = keys.getEntries();
            MainCLI.printMessage(entries.size() + " key(s) matched");
            boolean first = true;
            for (KeyInfo info : entries) {
                if (first) {
                    first = false;
                } else {
                    System.out.println();
                }
                KRAKeyCLI.printKeyInfo(info);
            }
            MainCLI.printMessage("Number of entries returned " + entries.size());
        } else {
            throw new Exception("Unsupported format: " + outputFormat);
        }
    }
}

