/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestFindCLI.class);
    public CACertRequestCLI certRequestCLI;

    public CACertRequestFindCLI(CACertRequestCLI certRequestCLI) {
        super("find", "Find certificate requests", (CLI)certRequestCLI);
        this.certRequestCLI = certRequestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = null;
        option = new Option(null, "status", true, "Request status (pending, cancelled, rejected, complete, all)");
        option.setArgName("status");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Request type (enrollment, renewal, revocation, all)");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
        option = new Option(null, "maxResults", true, "Maximum number of results");
        option.setArgName("maxResults");
        this.options.addOption(option);
        option = new Option(null, "timeout", true, "Search timeout");
        option.setArgName("maxTime");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String requestType;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String s = cmd.getOptionValue("start");
        RequestId start = s == null ? null : new RequestId(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("maxResults");
        Integer maxResults = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("maxTime");
        Integer maxTime = s == null ? null : Integer.valueOf(s);
        String requestState = cmd.getOptionValue("status");
        if (requestState != null && requestState.equals("all")) {
            requestState = null;
        }
        if ((requestType = cmd.getOptionValue("type")) != null && requestType.equals("all")) {
            requestType = null;
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certRequestCLI.getCertClient();
        CertRequestInfos response = certClient.listRequests(requestState, requestType, start, size, maxResults, maxTime);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (CertRequestInfo certRequest : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            CACertRequestCLI.printCertRequestInfo(certRequest);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

