/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.ocsp.LDAPStore;
import netscape.ldap.LDAPConnection;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLUpdater
extends Thread {
    public static Logger logger = LoggerFactory.getLogger(CRLUpdater.class);
    private LDAPConnection mC = null;
    private String mBaseDN = null;
    private int mSec = 0;
    private LDAPStore mStore = null;

    public CRLUpdater(LDAPStore store, LDAPConnection c, String baseDN, int sec) {
        this.mC = c;
        this.mSec = sec;
        this.mBaseDN = baseDN;
        this.mStore = store;
    }

    public void updateCRLCache() throws EBaseException {
        logger.info("LDAPStore: Updating CRL");
        X509CertImpl caCert = this.mStore.locateCACert(this.mC, this.mBaseDN);
        if (caCert == null) {
            logger.info("LDAPStore: Unable to find CA cert");
            return;
        }
        X509CRLImpl crl = this.mStore.locateCRL(this.mC, this.mBaseDN);
        if (crl == null) {
            logger.info("LDAPStore: Unable to find CRL");
            return;
        }
        logger.info("LDAPStore: Updating CRL cache");
        this.mStore.updateCRLHash(caCert, crl);
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.updateCRLCache();
            }
            catch (Exception e) {
                logger.error("Unable to update CRL cache: " + e.getMessage(), (Throwable)e);
            }
            try {
                CRLUpdater.sleep(this.mSec * 1000);
            }
            catch (Exception exception) {
            }
        }
    }
}

