/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.tomcat;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPKIAuthenticator
extends AuthenticatorBase {
    static final Logger logger = LoggerFactory.getLogger(AbstractPKIAuthenticator.class);
    public static final String BASIC_AUTHENTICATOR = "BASIC";
    public static final String FORM_AUTHENTICATOR = "FORM";
    String fallbackMethod = "BASIC";
    AuthenticatorBase sslAuthenticator = new SSLAuthenticator();
    AuthenticatorBase fallbackAuthenticator = new BasicAuthenticator();

    public AbstractPKIAuthenticator() {
        logger.info("PKIAuthenticator: Creating " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public String getFallbackMethod() {
        return this.fallbackMethod;
    }

    public void setFallbackMethod(String fallbackMethod) {
        logger.info("PKIAuthenticator: Fallback method: " + fallbackMethod);
        this.fallbackMethod = fallbackMethod;
        if (BASIC_AUTHENTICATOR.equalsIgnoreCase(fallbackMethod)) {
            this.fallbackAuthenticator = new BasicAuthenticator();
        } else if (FORM_AUTHENTICATOR.equalsIgnoreCase(fallbackMethod)) {
            this.fallbackAuthenticator = new FormAuthenticator();
        }
    }

    public boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        boolean result;
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            logger.info("PKIAuthenticator: Authenticate with client certificate authentication");
            wrapper = new HttpServletResponseWrapper(response){

                public void setHeader(String name, String value) {
                    logger.debug("PKIAuthenticator: SSL auth header: " + name + "=" + value);
                }

                public void sendError(int code) {
                    logger.debug("PKIAuthenticator: SSL auth return code: " + code);
                }
            };
            result = this.doSubAuthenticate((Authenticator)this.sslAuthenticator, request, (HttpServletResponse)wrapper);
        } else {
            logger.info("PKIAuthenticator: Authenticating with " + this.fallbackMethod + " authentication");
            wrapper = new HttpServletResponseWrapper(response){

                public void setHeader(String name, String value) {
                    logger.debug("PKIAuthenticator: Fallback auth header: " + name + "=" + value);
                }

                public void sendError(int code) {
                    logger.debug("PKIAuthenticator: Fallback auth return code: " + code);
                }
            };
            result = this.doSubAuthenticate((Authenticator)this.fallbackAuthenticator, request, (HttpServletResponse)wrapper);
        }
        if (result) {
            return true;
        }
        logger.info("PKIAuthenticator: Result: " + result);
        String realmName = this.doGetRealmName(request);
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + (realmName == null ? "Authentication required" : realmName) + "\"");
        response.sendError(401);
        return false;
    }

    public abstract boolean doSubAuthenticate(Authenticator var1, Request var2, HttpServletResponse var3) throws IOException;

    public abstract String doGetRealmName(Request var1);

    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }

    public void setContainer(Container container) {
        logger.debug("PKIAuthenticator: Setting container");
        super.setContainer(container);
        this.sslAuthenticator.setContainer(container);
        this.fallbackAuthenticator.setContainer(container);
    }

    protected void initInternal() throws LifecycleException {
        logger.debug("PKIAuthenticator: Initializing authenticators");
        super.initInternal();
        this.sslAuthenticator.setAlwaysUseSession(this.alwaysUseSession);
        this.sslAuthenticator.init();
        this.fallbackAuthenticator.setAlwaysUseSession(this.alwaysUseSession);
        this.fallbackAuthenticator.init();
    }

    public void startInternal() throws LifecycleException {
        logger.debug("PKIAuthenticator: Starting authenticators");
        super.startInternal();
        this.sslAuthenticator.start();
        this.fallbackAuthenticator.start();
    }

    public void stopInternal() throws LifecycleException {
        logger.debug("PKIAuthenticator: Stopping authenticators");
        super.stopInternal();
        this.sslAuthenticator.stop();
        this.fallbackAuthenticator.stop();
    }
}

