/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class KeyUsageExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    private static final String HTTP_INPUT = "HTTP_INPUT";
    protected static final boolean[] DEF_BITS = new boolean[9];
    protected int mCAPathLen = -1;
    protected ConfigStore mConfig;
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_DIGITAL_SIGNATURE = "digitalSignature";
    protected static final String PROP_NON_REPUDIATION = "nonRepudiation";
    protected static final String PROP_KEY_ENCIPHERMENT = "keyEncipherment";
    protected static final String PROP_DATA_ENCIPHERMENT = "dataEncipherment";
    protected static final String PROP_KEY_AGREEMENT = "keyAgreement";
    protected static final String PROP_KEY_CERTSIGN = "keyCertsign";
    protected static final String PROP_CRL_SIGN = "crlSign";
    protected static final String PROP_ENCIPHER_ONLY = "encipherOnly";
    protected static final String PROP_DECIPHER_ONLY = "decipherOnly";
    protected boolean mCritical;
    protected String mDigitalSignature;
    protected String mNonRepudiation;
    protected String mKeyEncipherment;
    protected String mDataEncipherment;
    protected String mKeyAgreement;
    protected String mKeyCertsign;
    protected String mCrlSign;
    protected String mEncipherOnly;
    protected String mDecipherOnly;
    protected KeyUsageExtension mKeyUsage;
    private static Vector<String> mDefParams = new Vector();

    public KeyUsageExt() {
        this.NAME = "KeyUsageExtPolicy";
        this.DESC = "Sets Key Usage Extension in certificates.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        if (certAuthority == null) {
            logger.error(CMS.getLogMessage((String)"CA_CANT_FIND_MANAGER", (Object[])new Object[0]));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Cannot find the Certificate Manager or Registration Manager"}));
        }
        CertificateChain caChain = certAuthority.getCACertChain();
        X509Certificate caCert = null;
        if (caChain != null) {
            caCert = caChain.getFirstCertificate();
            this.mCAPathLen = caCert.getBasicConstraints();
        }
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, true);
        this.mDigitalSignature = this.mConfig.getString(PROP_DIGITAL_SIGNATURE, HTTP_INPUT);
        this.mNonRepudiation = this.mConfig.getString(PROP_NON_REPUDIATION, HTTP_INPUT);
        this.mKeyEncipherment = this.mConfig.getString(PROP_KEY_ENCIPHERMENT, HTTP_INPUT);
        this.mDataEncipherment = this.mConfig.getString(PROP_DATA_ENCIPHERMENT, HTTP_INPUT);
        this.mKeyAgreement = this.mConfig.getString(PROP_KEY_AGREEMENT, HTTP_INPUT);
        this.mKeyCertsign = this.mConfig.getString(PROP_KEY_CERTSIGN, HTTP_INPUT);
        this.mCrlSign = this.mConfig.getString(PROP_CRL_SIGN, HTTP_INPUT);
        this.mEncipherOnly = this.mConfig.getString(PROP_ENCIPHER_ONLY, HTTP_INPUT);
        this.mDecipherOnly = this.mConfig.getString(PROP_DECIPHER_ONLY, HTTP_INPUT);
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            KeyUsageExtension ext = null;
            if (extensions != null) {
                try {
                    ext = (KeyUsageExtension)extensions.get("KeyUsage");
                }
                catch (IOException e) {
                    ext = null;
                }
                if (ext != null) {
                    boolean[] bits;
                    if (this.mCAPathLen == 0 && ((bits = ext.getBits()).length > 5 && bits[5] || bits.length > 6 && bits[6])) {
                        this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_SUB_CA_CERTS_ALLOWED", (String[])new String[0]), this.NAME);
                        return PolicyResult.REJECTED;
                    }
                    return PolicyResult.ACCEPTED;
                }
            } else if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            boolean[] bits = new boolean[]{this.getBit("digital_signature", this.mDigitalSignature, req), this.getBit("non_repudiation", this.mNonRepudiation, req), this.getBit("key_encipherment", this.mKeyEncipherment, req), this.getBit("data_encipherment", this.mDataEncipherment, req), this.getBit("key_agreement", this.mKeyAgreement, req), this.getBit("key_certsign", this.mKeyCertsign, req), this.getBit("crl_sign", this.mCrlSign, req), this.getBit("encipher_only", this.mEncipherOnly, req), this.getBit("decipher_only", this.mDecipherOnly, req)};
            boolean bitset = false;
            for (int i = 0; i < bits.length; ++i) {
                if (!bits[i]) continue;
                bitset = true;
                break;
            }
            if (!bitset) {
                logger.warn(CMS.getLogMessage((String)"POLICY_NO_KEYUSAGE_EXTENSION_BITS_SET", (Object[])new Object[]{this.NAME}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_KEYUSAGE_EXTENSION_BITS_SET", (String[])new String[0]), this.NAME);
                return PolicyResult.REJECTED;
            }
            try {
                this.mKeyUsage = new KeyUsageExtension(this.mCritical, bits);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            extensions.set("KeyUsage", (Object)this.mKeyUsage);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        params.addElement("digitalSignature=" + this.mDigitalSignature);
        params.addElement("nonRepudiation=" + this.mNonRepudiation);
        params.addElement("keyEncipherment=" + this.mKeyEncipherment);
        params.addElement("dataEncipherment=" + this.mDataEncipherment);
        params.addElement("keyAgreement=" + this.mKeyAgreement);
        params.addElement("keyCertsign=" + this.mKeyCertsign);
        params.addElement("crlSign=" + this.mCrlSign);
        params.addElement("encipherOnly=" + this.mEncipherOnly);
        params.addElement("decipherOnly=" + this.mDecipherOnly);
        return params;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: SHOULD be critical", "digitalSignature;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "nonRepudiation;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "keyEncipherment;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "dataEncipherment;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "keyAgreement;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "keyCertsign;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "crlSign;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "encipherOnly;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "decipherOnly;choice(true,false,HTTP_INPUT);true means always set this bit, false means don't set this bit, HTTP_INPUT means get this bit from the HTTP input", "HELP_TOKEN;configuration-policyrules-keyusage", "HELP_TEXT;Adds Key Usage Extension; See in RFC 2459 (4.2.1.3)"};
        return params;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    private boolean getBit(String usage, String choice, Request req) {
        if (choice.equals(HTTP_INPUT) && (choice = req.getExtDataInString("HTTP_PARAMS", usage)) == null) {
            choice = "false";
        }
        return Boolean.valueOf(choice);
    }

    static {
        mDefParams.addElement("critical=true");
        mDefParams.addElement("digitalSignature=");
        mDefParams.addElement("nonRepudiation=");
        mDefParams.addElement("keyEncipherment=");
        mDefParams.addElement("dataEncipherment=");
        mDefParams.addElement("keyAgreement=");
        mDefParams.addElement("keyCertsign=");
        mDefParams.addElement("crlSign=");
        mDefParams.addElement("encipherOnly=");
        mDefParams.addElement("decipherOnly=");
    }
}

