/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNameUtil;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthInfoAccessExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(AuthInfoAccessExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_AD = "ad";
    protected static final String PROP_METHOD = "method";
    protected static final String PROP_LOCATION = "location";
    protected static final String PROP_LOCATION_TYPE = "location_type";
    protected static final String PROP_NUM_ADS = "numADs";
    public static final int MAX_AD = 5;
    public ConfigStore mConfig;

    public AuthInfoAccessExt() {
        this.NAME = "AuthInfoAccessExt";
        this.DESC = "Sets authority information access extension for certificates";
    }

    public String[] getExtendedPluginInfo() {
        Vector<Object> v = new Vector<Object>();
        v.addElement("critical;boolean;RFC 2459 recommendation: This extension MUST be non-critical.");
        v.addElement("numADs;number;The total number of access descriptions.");
        v.addElement("HELP_TEXT;Adds Authority Info Access Extension. Defined in RFC 2459 (4.2.2.1)");
        v.addElement("HELP_TOKEN;configuration-policyrules-authinfoaccess");
        for (int i = 0; i < 5; ++i) {
            v.addElement(PROP_AD + Integer.toString(i) + "_method;string;A unique,valid OID specified in dot-separated numeric component notation. e.g. 1.3.6.1.5.5.7.48.1 (ocsp), 1.3.6.1.5.5.7.48.2 (caIssuers), 2.16.840.1.113730.1.16.1 (renewal)");
            v.addElement(PROP_AD + Integer.toString(i) + "_location_type;choice(rfc822Name,directoryName,dNSName,ediPartyName,URL,iPAddress,OID,otherName);GeneralName choice. See RFC 2459 appendix B2 on GeneralName.");
            v.addElement(PROP_AD + Integer.toString(i) + "_location;string;Value according to the GeneralName choice.");
        }
        return Utils.getStringArrayFromVector(v);
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
    }

    private Enumeration<Vector<Serializable>> getAccessDescriptions() throws EBaseException {
        Vector ads = new Vector();
        int i = 0;
        while (true) {
            ObjectIdentifier methodOID = null;
            String method = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_method", null);
            if (method == null || (method = method.trim()).equals("")) break;
            try {
                methodOID = method.equalsIgnoreCase("ocsp") ? ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.48.1") : (method.equalsIgnoreCase("caIssuers") ? ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.48.2") : (method.equalsIgnoreCase("renewal") ? ObjectIdentifier.getObjectIdentifier((String)"2.16.840.1.113730.1.16.1") : ObjectIdentifier.getObjectIdentifier((String)method)));
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_ATTRIBUTE_NAME_CAN_NOT_BE_RESOLVED", (String[])new String[]{method}));
            }
            String location_type = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_location_type", null);
            String location = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_location", null);
            if (location == null) break;
            GeneralName gn = GeneralNameUtil.form_GeneralName((String)location_type, (String)location);
            Vector<Object> e = new Vector<Object>();
            e.addElement(methodOID);
            e.addElement(gn);
            ads.addElement(e);
            ++i;
        }
        return ads.elements();
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.NAME}), "");
            return PolicyResult.REJECTED;
        }
        for (int j = 0; j < ci.length; ++j) {
            X509CertInfo certInfo = ci[j];
            if (certInfo == null) {
                logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, ""}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, "Configuration Info Error"}), "");
                return PolicyResult.REJECTED;
            }
            try {
                CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
                Enumeration<Vector<Serializable>> e = this.getAccessDescriptions();
                if (!e.hasMoreElements()) {
                    return res;
                }
                if (extensions == null) {
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    extensions = new CertificateExtensions();
                    certInfo.set("extensions", (Object)extensions);
                } else {
                    try {
                        extensions.delete("AuthInfoAccessExtension");
                        logger.warn("Previous extension deleted: AuthInfoAccessExtension");
                    }
                    catch (IOException ex) {
                        logger.warn("Unable to delete extension: AuthInfoAccessExtension", (Throwable)ex);
                    }
                }
                AuthInfoAccessExtension aiaExt = new AuthInfoAccessExtension(this.mConfig.getBoolean(PROP_CRITICAL, false));
                while (e.hasMoreElements()) {
                    Vector<Serializable> ad = e.nextElement();
                    ObjectIdentifier oid = (ObjectIdentifier)ad.elementAt(0);
                    GeneralName gn = (GeneralName)ad.elementAt(1);
                    aiaExt.addAccessDescription(oid, gn);
                }
                extensions.set("AuthInfoAccessExtension", (Object)aiaExt);
                continue;
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, e.getMessage()}), "");
                return PolicyResult.REJECTED;
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, "Configuration Info Error"}), "");
                return PolicyResult.REJECTED;
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, "Certificate Info Error"}), "");
                return PolicyResult.REJECTED;
            }
        }
        return res;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        try {
            params.addElement("critical=" + this.mConfig.getBoolean(PROP_CRITICAL, false));
        }
        catch (EBaseException e) {
            params.addElement("critical=false");
        }
        int numADs = 5;
        try {
            numADs = this.mConfig.getInteger(PROP_NUM_ADS, 5);
            params.addElement("numADs=" + numADs);
        }
        catch (EBaseException e) {
            params.addElement("numADs=5");
        }
        for (int i = 0; i < numADs; ++i) {
            String method = null;
            try {
                method = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_method", "");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            params.addElement(PROP_AD + Integer.toString(i) + "_method=" + method);
            String location_type = null;
            try {
                location_type = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_location_type", "URL");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            params.addElement(PROP_AD + Integer.toString(i) + "_location_type=" + location_type);
            String location = null;
            try {
                location = this.mConfig.getString(PROP_AD + Integer.toString(i) + "_location", "");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            params.addElement(PROP_AD + Integer.toString(i) + "_location=" + location);
        }
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("numADs=5");
        for (int i = 0; i < 5; ++i) {
            defParams.addElement(PROP_AD + Integer.toString(i) + "_method=");
            defParams.addElement(PROP_AD + Integer.toString(i) + "_location_type=URL");
            defParams.addElement(PROP_AD + Integer.toString(i) + "_location=");
        }
        return defParams;
    }
}

