/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caUpdateDir", urlPatterns={"/agent/ca/updateDir"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/agent/ca/updateDir.template"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caUpdateDir"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.directory")})
public class UpdateDir
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(UpdateDir.class);
    private static final long serialVersionUID = 3063889978908136789L;
    private static final String TPL_FILE = "updateDir.template";
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CRL = 1;
    private static final int UPDATE_CA = 2;
    private static final int UPDATE_VALID = 3;
    private static final int VALID_FROM = 4;
    private static final int VALID_TO = 5;
    private static final int UPDATE_EXPIRED = 6;
    private static final int EXPIRED_FROM = 7;
    private static final int EXPIRED_TO = 8;
    private static final int UPDATE_REVOKED = 9;
    private static final int REVOKED_FROM = 10;
    private static final int REVOKED_TO = 11;
    private static final int CHECK_FLAG = 12;
    private static final String[] updateName = new String[]{"updateAll", "updateCRL", "updateCA", "updateValid", "validFrom", "validTo", "updateExpired", "expiredFrom", "expiredTo", "updateRevoked", "revokedFrom", "revokedTo", "checkFlag"};
    private String mFormPath = null;
    private CertificateAuthority mCA;
    private CAPublisherProcessor mPublisherProcessor;
    private CRLRepository mCRLRepository;
    private boolean mClonedCA = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/updateDir.template";
        this.mCA = engine.getCA();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mCRLRepository = engine.getCRLRepository();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "update");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        EBaseException error = null;
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            String crlIssuingPointId = req.getParameter("crlIssuingPoint");
            if (this.mPublisherProcessor == null || !this.mPublisherProcessor.isCertPublishingEnabled() && !this.mPublisherProcessor.isCRLPublishingEnabled()) {
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_PUB_MODULE", (String[])new String[0]));
            }
            String[] updateValue = new String[updateName.length];
            for (int i = 0; i < updateName.length; ++i) {
                updateValue[i] = req.getParameter(updateName[i]);
            }
            String masterHost = cs.getString("master.ca.agent.host", "");
            String masterPort = cs.getString("master.ca.agent.port", "");
            if (masterHost != null && masterHost.length() > 0 && masterPort != null && masterPort.length() > 0) {
                this.mClonedCA = true;
            }
            this.process(header, crlIssuingPointId, updateValue, locale[0]);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void updateCRLIssuingPoint(ArgBlock header, String crlIssuingPointId, CRLIssuingPoint crlIssuingPoint, Locale locale) {
        SessionContext sc = SessionContext.getContext();
        sc.put((Object)"issuingPointId", (Object)crlIssuingPointId);
        sc.put((Object)"isDeltaCRL", (Object)"false");
        CRLIssuingPointRecord crlRecord = null;
        try {
            if (this.mCRLRepository != null) {
                crlRecord = this.mCRLRepository.readCRLIssuingPointRecord(crlIssuingPointId);
            }
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_GET_CRL_RECORD", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (crlRecord == null) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{crlIssuingPointId}));
            header.addStringValue("crlPublished", "Failure");
            header.addStringValue("crlError", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_NOT_YET_UPDATED", (String[])new String[0])).toString());
        } else {
            String publishDN = crlIssuingPoint != null ? crlIssuingPoint.getPublishDN() : null;
            byte[] crlbytes = crlRecord.getCRL();
            if (crlbytes == null) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{""}));
                header.addStringValue("crlPublished", "Failure");
                header.addStringValue("crlError", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_CRL_NOT_YET_UPDATED", (String[])new String[0])).toString());
            } else {
                X509CRLImpl crl = null;
                try {
                    crl = new X509CRLImpl(crlbytes);
                }
                catch (Exception e) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (crl == null) {
                    header.addStringValue("crlPublished", "Failure");
                    header.addStringValue("crlError", new ECMSGWException(CMS.getUserMessage((Locale)locale, (String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0])).toString());
                } else {
                    try {
                        if (publishDN != null) {
                            this.mPublisherProcessor.publishCRL(publishDN, (X509CRL)crl);
                        } else {
                            this.mPublisherProcessor.publishCRL(crl, crlIssuingPointId);
                        }
                        header.addStringValue("crlPublished", "Success");
                    }
                    catch (ELdapException e) {
                        header.addStringValue("crlPublished", "Failure");
                        header.addStringValue("crlError", e.toString(locale));
                        logger.warn(CMS.getLogMessage((String)"LDAP_ERROR_PUBLISH_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
            }
            sc.put((Object)"isDeltaCRL", (Object)"true");
            byte[] deltaCrlBytes = crlRecord.getDeltaCRL();
            if (deltaCrlBytes != null) {
                X509CRLImpl deltaCrl = null;
                try {
                    deltaCrl = new X509CRLImpl(deltaCrlBytes);
                }
                catch (Exception e) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_DECODE_DELTA_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                boolean goodDelta = false;
                if (this.mClonedCA) {
                    BigInteger crlNumber = crlRecord.getCRLNumber();
                    BigInteger deltaNumber = crlRecord.getDeltaCRLNumber();
                    Long deltaCRLSize = crlRecord.getDeltaCRLSize();
                    if (deltaCRLSize != null && deltaCRLSize > -1L && crlNumber != null && deltaNumber != null && deltaNumber.compareTo(crlNumber) >= 0) {
                        goodDelta = true;
                    }
                }
                if (deltaCrl != null && (this.mClonedCA && goodDelta || crlIssuingPoint != null && crlIssuingPoint.isThisCurrentDeltaCRL(deltaCrl))) {
                    try {
                        if (publishDN != null) {
                            this.mPublisherProcessor.publishCRL(publishDN, (X509CRL)deltaCrl);
                        } else {
                            this.mPublisherProcessor.publishCRL(deltaCrl, crlIssuingPointId);
                        }
                    }
                    catch (ELdapException e) {
                        logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_PUBLISH_DELTA_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
            }
        }
    }

    private void process(ArgBlock header, String crlIssuingPointId, String[] updateValue, Locale locale) throws EBaseException {
        RequestId rid;
        Request r;
        String ridString;
        MetaInfo metaInfo;
        X509CertImpl o;
        X509CertImpl cert;
        CertRecord certRecord;
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certificateRepository = engine.getCertificateRepository();
        if (updateValue[0] != null && updateValue[0].equalsIgnoreCase("yes") || updateValue[1] != null && updateValue[1].equalsIgnoreCase("yes")) {
            if (crlIssuingPointId != null) {
                CRLIssuingPoint ip;
                Enumeration<CRLIssuingPoint> ips = Collections.enumeration(engine.getCRLIssuingPoints());
                while (ips.hasMoreElements() && !crlIssuingPointId.equals((ip = ips.nextElement()).getId())) {
                    if (ips.hasMoreElements()) continue;
                    crlIssuingPointId = null;
                }
            }
            if (crlIssuingPointId == null) {
                if (this.mClonedCA && this.mCRLRepository != null) {
                    Vector<String> ipNames = this.mCRLRepository.getIssuingPointsNames();
                    if (ipNames != null && ipNames.size() > 0) {
                        for (int i = 0; i < ipNames.size(); ++i) {
                            String ipName = ipNames.elementAt(i);
                            this.updateCRLIssuingPoint(header, ipName, null, locale);
                        }
                    }
                } else {
                    Enumeration<CRLIssuingPoint> oips = Collections.enumeration(engine.getCRLIssuingPoints());
                    while (oips.hasMoreElements()) {
                        CRLIssuingPoint oip = oips.nextElement();
                        this.updateCRLIssuingPoint(header, oip.getId(), oip, locale);
                    }
                }
            } else {
                CRLIssuingPoint crlIssuingPoint = engine.getCRLIssuingPoint(crlIssuingPointId);
                this.updateCRLIssuingPoint(header, crlIssuingPointId, crlIssuingPoint, locale);
            }
        }
        if (updateValue[0] != null && updateValue[0].equalsIgnoreCase("yes") || updateValue[2] != null && updateValue[2].equalsIgnoreCase("yes")) {
            X509CertImpl caCert = this.mCA.getSigningUnit().getCertImpl();
            try {
                this.mPublisherProcessor.publishCACert((X509Certificate)caCert);
                header.addStringValue("caCertPublished", "Success");
            }
            catch (ELdapException e) {
                logger.warn(CMS.getLogMessage((String)"LDAP_ERROR_PUBLISH_CACERT_1", (Object[])new Object[]{caCert.getSerialNumber().toString(16), e.toString()}));
                header.addStringValue("caCertPublished", "Failure");
                header.addStringValue("caCertError", e.toString(locale));
            }
        }
        if (updateValue[0] != null && updateValue[0].equalsIgnoreCase("yes") || updateValue[3] != null && updateValue[3].equalsIgnoreCase("yes")) {
            if (certificateRepository != null) {
                if (updateValue[4].startsWith("0x")) {
                    updateValue[4] = this.hexToDecimal(updateValue[4]);
                }
                if (updateValue[5].startsWith("0x")) {
                    updateValue[5] = this.hexToDecimal(updateValue[5]);
                }
                Enumeration<CertRecord> validCerts = null;
                validCerts = updateValue[12] != null && updateValue[12].equalsIgnoreCase("yes") ? certificateRepository.getValidNotPublishedCertificates(updateValue[4], updateValue[5]) : certificateRepository.getValidCertificates(updateValue[4], updateValue[5]);
                int i = 0;
                int l = 0;
                Object validCertsError = "";
                if (validCerts != null) {
                    while (validCerts.hasMoreElements()) {
                        certRecord = validCerts.nextElement();
                        cert = null;
                        o = certRecord.getCertificate();
                        if (o instanceof X509CertImpl) {
                            cert = o;
                        }
                        metaInfo = null;
                        ridString = null;
                        metaInfo = (MetaInfo)certRecord.get("certMetaInfo");
                        if (metaInfo == null) {
                            logger.warn(CMS.getLogMessage((String)"CMSGW_FAIL_GET_ICERT_RECORD", (Object[])new Object[]{cert.getSerialNumber().toString(16)}));
                        } else {
                            ridString = (String)metaInfo.get("requestId");
                        }
                        r = null;
                        if (ridString != null) {
                            rid = new RequestId(ridString);
                            r = this.requestRepository.readRequest(rid);
                        }
                        try {
                            ++l;
                            SessionContext sc = SessionContext.getContext();
                            if (r == null) {
                                if (CertUtils.isEncryptionCert((X509CertImpl)cert)) {
                                    sc.put((Object)"isEncryptionCert", (Object)"true");
                                } else {
                                    sc.put((Object)"isEncryptionCert", (Object)"false");
                                }
                                this.mPublisherProcessor.publishCert((X509Certificate)cert, null);
                            } else {
                                if (CertUtils.isEncryptionCert((X509CertImpl)cert)) {
                                    r.setExtData("isEncryptionCert", "true");
                                } else {
                                    r.setExtData("isEncryptionCert", "false");
                                }
                                this.mPublisherProcessor.publishCert((X509Certificate)cert, r);
                            }
                            ++i;
                        }
                        catch (Exception e) {
                            logger.warn(CMS.getLogMessage((String)"CMSGW_FAIL_PUBLISH_CERT", (Object[])new Object[]{certRecord.getSerialNumber().toString(16), e.toString()}));
                            validCertsError = (String)validCertsError + "Failed to publish certificate: 0x" + certRecord.getSerialNumber().toString(16) + ".\n <BR> &nbsp;&nbsp;&nbsp;&nbsp;";
                        }
                    }
                }
                if (i > 0 && i == l) {
                    header.addStringValue("validCertsPublished", "Success");
                    if (i == 1) {
                        header.addStringValue("validCertsError", i + " valid certificate is published in the directory.");
                    } else {
                        header.addStringValue("validCertsError", i + " valid certificates are published in the directory.");
                    }
                } else if (l == 0) {
                    header.addStringValue("validCertsPublished", "No");
                } else {
                    header.addStringValue("validCertsPublished", "Failure");
                    header.addStringValue("validCertsError", (String)validCertsError);
                }
            } else {
                header.addStringValue("validCertsPublished", "Failure");
                header.addStringValue("validCertsError", "Certificate repository is unavailable.");
            }
        }
        if (updateValue[0] != null && updateValue[0].equalsIgnoreCase("yes") || updateValue[6] != null && updateValue[6].equalsIgnoreCase("yes")) {
            if (certificateRepository != null) {
                if (updateValue[7].startsWith("0x")) {
                    updateValue[7] = this.hexToDecimal(updateValue[7]);
                }
                if (updateValue[8].startsWith("0x")) {
                    updateValue[8] = this.hexToDecimal(updateValue[8]);
                }
                Enumeration<CertRecord> expiredCerts = null;
                expiredCerts = updateValue[12] != null && updateValue[12].equalsIgnoreCase("yes") ? certificateRepository.getExpiredPublishedCertificates(updateValue[7], updateValue[8]) : certificateRepository.getExpiredCertificates(updateValue[7], updateValue[8]);
                int i = 0;
                int l = 0;
                StringBuffer expiredCertsError = new StringBuffer();
                if (expiredCerts != null) {
                    while (expiredCerts.hasMoreElements()) {
                        certRecord = expiredCerts.nextElement();
                        cert = null;
                        o = certRecord.getCertificate();
                        if (o instanceof X509CertImpl) {
                            cert = o;
                        }
                        metaInfo = null;
                        ridString = null;
                        metaInfo = (MetaInfo)certRecord.get("certMetaInfo");
                        if (metaInfo == null) {
                            logger.warn(CMS.getLogMessage((String)"CMSGW_FAIL_GET_ICERT_RECORD", (Object[])new Object[]{cert.getSerialNumber().toString(16)}));
                        } else {
                            ridString = (String)metaInfo.get("requestId");
                        }
                        r = null;
                        if (ridString != null) {
                            rid = new RequestId(ridString);
                            r = this.requestRepository.readRequest(rid);
                        }
                        try {
                            ++l;
                            if (r == null) {
                                this.mPublisherProcessor.unpublishCert((X509Certificate)cert, null);
                            } else {
                                this.mPublisherProcessor.unpublishCert((X509Certificate)cert, r);
                            }
                            ++i;
                        }
                        catch (Exception e) {
                            logger.warn(CMS.getLogMessage((String)"LDAP_ERROR_UNPUBLISH_CERT", (Object[])new Object[]{certRecord.getSerialNumber().toString(16), e.toString()}));
                            expiredCertsError.append("Failed to unpublish certificate: 0x");
                            expiredCertsError.append(certRecord.getSerialNumber().toString(16));
                            expiredCertsError.append(".\n <BR> &nbsp;&nbsp;&nbsp;&nbsp;");
                        }
                    }
                }
                if (i > 0 && i == l) {
                    header.addStringValue("expiredCertsUnpublished", "Success");
                    if (i == 1) {
                        header.addStringValue("expiredCertsError", i + " expired certificate is unpublished in the directory.");
                    } else {
                        header.addStringValue("expiredCertsError", i + " expired certificates are unpublished in the directory.");
                    }
                } else if (l == 0) {
                    header.addStringValue("expiredCertsUnpublished", "No");
                } else {
                    header.addStringValue("expiredCertsUnpublished", "Failure");
                    header.addStringValue("expiredCertsError", expiredCertsError.toString());
                }
            } else {
                header.addStringValue("expiredCertsUnpublished", "Failure");
                header.addStringValue("expiredCertsError", "Certificate repository is unavailable.");
            }
        }
        if (updateValue[0] != null && updateValue[0].equalsIgnoreCase("yes") || updateValue[9] != null && updateValue[9].equalsIgnoreCase("yes")) {
            if (certificateRepository != null) {
                if (updateValue[10].startsWith("0x")) {
                    updateValue[10] = this.hexToDecimal(updateValue[10]);
                }
                if (updateValue[11].startsWith("0x")) {
                    updateValue[11] = this.hexToDecimal(updateValue[11]);
                }
                Enumeration<CertRecord> revokedCerts = null;
                revokedCerts = updateValue[12] != null && updateValue[12].equalsIgnoreCase("yes") ? certificateRepository.getRevokedPublishedCertificates(updateValue[10], updateValue[11]) : certificateRepository.getRevokedCertificates(updateValue[10], updateValue[11]);
                int i = 0;
                int l = 0;
                Object revokedCertsError = "";
                if (revokedCerts != null) {
                    while (revokedCerts.hasMoreElements()) {
                        certRecord = revokedCerts.nextElement();
                        cert = null;
                        o = certRecord.getCertificate();
                        if (o instanceof X509CertImpl) {
                            cert = o;
                        }
                        metaInfo = null;
                        ridString = null;
                        metaInfo = (MetaInfo)certRecord.get("certMetaInfo");
                        if (metaInfo == null) {
                            logger.warn(CMS.getLogMessage((String)"CMSGW_FAIL_GET_ICERT_RECORD", (Object[])new Object[]{cert.getSerialNumber().toString(16)}));
                        } else {
                            ridString = (String)metaInfo.get("requestId");
                        }
                        r = null;
                        if (ridString != null) {
                            rid = new RequestId(ridString);
                            r = this.requestRepository.readRequest(rid);
                        }
                        try {
                            ++l;
                            if (r == null) {
                                this.mPublisherProcessor.unpublishCert((X509Certificate)cert, null);
                            } else {
                                this.mPublisherProcessor.unpublishCert((X509Certificate)cert, r);
                            }
                            ++i;
                        }
                        catch (Exception e) {
                            logger.warn(CMS.getLogMessage((String)"LDAP_ERROR_UNPUBLISH_CERT", (Object[])new Object[]{certRecord.getSerialNumber().toString(16), e.toString()}));
                            revokedCertsError = (String)revokedCertsError + "Failed to unpublish certificate: 0x" + certRecord.getSerialNumber().toString(16) + ".\n <BR> &nbsp;&nbsp;&nbsp;&nbsp;";
                        }
                    }
                }
                if (i > 0 && i == l) {
                    header.addStringValue("revokedCertsUnpublished", "Success");
                    if (i == 1) {
                        header.addStringValue("revokedCertsError", i + " revoked certificate is unpublished in the directory.");
                    } else {
                        header.addStringValue("revokedCertsError", i + " revoked certificates are unpublished in the directory.");
                    }
                } else if (l == 0) {
                    header.addStringValue("revokedCertsUnpublished", "No");
                } else {
                    header.addStringValue("revokedCertsUnpublished", "Failure");
                    header.addStringValue("revokedCertsError", (String)revokedCertsError);
                }
            } else {
                header.addStringValue("revokedCertsUnpublished", "Failure");
                header.addStringValue("revokedCertsError", "Certificate repository is unavailable.");
            }
        }
    }

    private String hexToDecimal(String hex) {
        String newHex = hex.substring(2);
        BigInteger bi = new BigInteger(newHex, 16);
        return bi.toString();
    }
}

