/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.cms.publish.mappers.MapDNPattern;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSimpleMap
extends Mapper
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapSimpleMap.class);
    protected static final String PROP_DNPATTERN = "dnPattern";
    protected String mDnPattern = null;
    private boolean mInited = false;
    protected ConfigStore mConfig;
    protected MapDNPattern mPattern = null;
    protected String[] mReqAttrs = null;
    protected String[] mCertAttrs = null;
    public static final String DEFAULT_DNPATTERN = "UID=$req.HTTP_PARAMS.UID,  OU=people, O=$subj.o, C=$subj.c";

    public LdapSimpleMap(String dnPattern) {
        try {
            this.init(dnPattern);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    public LdapSimpleMap() {
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"dnPattern;string;Describes how to form the Ldap Subject name in the directory.  Example 1:  'uid=CertMgr, o=Fedora'.  Example 2: 'uid=$req.HTTP_PARAMS.uid, E=$ext.SubjectAlternativeName.RFC822Name, ou=$subj.ou'. $req means: take the attribute from the request. $subj means: take the attribute from the certificate subject name. $ext means: take the attribute from the certificate extension", "HELP_TOKEN;configuration-ldappublish-mapper-simplemapper", "HELP_TEXT;Describes how to form the LDAP DN of the entry to publish to"};
        return params;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        String dnPattern = this.mConfig.getString(PROP_DNPATTERN);
        this.init(dnPattern);
    }

    protected void init(String dnPattern) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mDnPattern = dnPattern;
        if (this.mDnPattern == null || this.mDnPattern.length() == 0) {
            this.mDnPattern = DEFAULT_DNPATTERN;
        }
        try {
            this.mPattern = new MapDNPattern(this.mDnPattern);
        }
        catch (ELdapException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_PATTERN_INIT", (Object[])new Object[]{dnPattern, e.toString()}), (Throwable)e);
            throw new EBaseException("falied to init with pattern " + dnPattern + " " + e, (Throwable)e);
        }
        this.mInited = true;
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        return this.map(conn, null, obj);
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        String dn = null;
        try {
            dn = this.formDN(req, obj);
            if (dn == null) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_DN_NOT_FORMED", (Object[])new Object[0]));
                String s1 = "";
                if (req != null) {
                    s1 = req.getRequestId().toString();
                }
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_DN_MATCH", (String[])new String[]{s1}));
            }
            int scope = 0;
            String filter = "(objectclass=*)";
            String[] attrs = new String[]{"1.1"};
            logger.info("LdapSimpleMap: Searching for " + dn);
            LDAPSearchResults results = conn.search(dn, scope, filter, attrs, false);
            LDAPEntry entry = results.next();
            if (results.hasMoreElements()) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_MORE_THAN_ONE_ENTRY", (Object[])new Object[]{dn, req == null ? "" : req.getRequestId().toString()}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_MORE_THAN_ONE_ENTRY", (String[])new String[]{req == null ? "" : req.getRequestId().toString()}));
            }
            if (entry == null) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_ENTRY_NOT_FOUND", (Object[])new Object[]{dn, req == null ? "" : req.getRequestId().toString()}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{"null entry"}));
            }
            return entry.getDN();
        }
        catch (ELdapException e) {
            throw e;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                logger.error("Entry not found: " + dn);
                throw new ELdapException("Entry not found: " + dn, (Throwable)e);
            }
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{"", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_EXCEPTION_CAUGHT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    private String formDN(Request req, Object obj) throws EBaseException, ELdapException {
        X500Name subjectDN = null;
        CertificateExtensions certExt = null;
        try {
            X509Certificate cert = (X509Certificate)obj;
            subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapSimpleMap: cert subject dn:" + subjectDN);
            X509CertInfo info = (X509CertInfo)((X509CertImpl)cert).get("x509.info");
            certExt = (CertificateExtensions)info.get("extensions");
        }
        catch (CertificateParsingException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (ClassCastException e) {
            try {
                X509CRLImpl crl = (X509CRLImpl)obj;
                subjectDN = (X500Name)crl.getIssuerDN();
            }
            catch (ClassCastException ex) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_PUBLISH_OBJ_NOT_SUPPORTED", (Object[])new Object[]{req == null ? "" : req.getRequestId().toString()}), (Throwable)ex);
                return null;
            }
        }
        try {
            String dn = this.mPattern.formDN(req, subjectDN, certExt);
            return dn;
        }
        catch (ELdapException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_FORM_DN", (Object[])new Object[]{req == null ? "" : req.getRequestId().toString(), e.toString()}), (Throwable)e);
            throw e;
        }
    }

    public String getImplName() {
        return "LdapSimpleMap";
    }

    public String getDescription() {
        return "LdapSimpleMap";
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("dnPattern=");
        return v;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        try {
            if (this.mDnPattern == null) {
                v.addElement("dnPattern=");
            } else {
                v.addElement("dnPattern=" + this.mConfig.getString(PROP_DNPATTERN));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }
}

