/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyMap;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.PolicyMappingsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMappingsExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(PolicyMappingsExtDefault.class);
    public static final String CONFIG_CRITICAL = "policyMappingsCritical";
    public static final String CONFIG_NUM_POLICY_MAPPINGS = "policyMappingsNum";
    public static final String CONFIG_ISSUER_DOMAIN_POLICY = "policyMappingsIssuerDomainPolicy_";
    public static final String CONFIG_SUBJECT_DOMAIN_POLICY = "policyMappingsSubjectDomainPolicy_";
    public static final String CONFIG_ENABLE = "policyMappingsEnable_";
    public static final String VAL_CRITICAL = "policyMappingsCritical";
    public static final String VAL_DOMAINS = "policyMappingsDomains";
    private static final String ISSUER_POLICY_ID = "Issuer Policy Id";
    private static final String SUBJECT_POLICY_ID = "Subject Policy Id";
    private static final String POLICY_ID_ENABLE = "Enable";
    private static final int DEF_NUM_MAPPINGS = 1;
    private static final int MAX_NUM_MAPPINGS = 100;

    protected int getNumMappings() {
        int num = 1;
        String numMappings = this.getConfig(CONFIG_NUM_POLICY_MAPPINGS);
        if (numMappings != null) {
            try {
                num = Integer.parseInt(numMappings);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_NUM_POLICY_MAPPINGS)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POLICY_MAPPINGS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POLICY_MAPPINGS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("policyMappingsCritical");
        this.addValueName(VAL_DOMAINS);
        this.addConfigName("policyMappingsCritical");
        int num = this.getNumMappings();
        this.addConfigName(CONFIG_NUM_POLICY_MAPPINGS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_ISSUER_DOMAIN_POLICY + i);
            this.addConfigName(CONFIG_SUBJECT_DOMAIN_POLICY + i);
            this.addConfigName(CONFIG_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("policyMappingsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ISSUER_DOMAIN_POLICY)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_DOMAIN_POLICY", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_SUBJECT_DOMAIN_POLICY)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_DOMAIN_POLICY", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ENABLE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_POLICY_MAPPINGS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_POLICY_MAPPINGS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("policyMappingsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_DOMAINS)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DOMAINS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            PolicyMappingsExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("policyMappingsCritical")) {
                ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals(VAL_DOMAINS)) {
                ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Vector<NameValuePairs> v = this.parseRecords(value);
                int size = v.size();
                String issuerPolicyId = null;
                String subjectPolicyId = null;
                String enable = null;
                Vector<CertificatePolicyMap> policyMaps = new Vector<CertificatePolicyMap>();
                for (int i = 0; i < size; ++i) {
                    NameValuePairs nvps = v.elementAt(i);
                    for (String name1 : nvps.keySet()) {
                        if (name1.equals(ISSUER_POLICY_ID)) {
                            issuerPolicyId = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(SUBJECT_POLICY_ID)) {
                            subjectPolicyId = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (!name1.equals(POLICY_ID_ENABLE)) continue;
                        enable = (String)nvps.get((Object)name1);
                    }
                    if (enable == null || !enable.equals("true")) continue;
                    if (issuerPolicyId == null || issuerPolicyId.length() == 0 || subjectPolicyId == null || subjectPolicyId.length() == 0) {
                        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POLICY_ID_NOT_FOUND", (String[])new String[0]));
                    }
                    CertificatePolicyMap map = new CertificatePolicyMap(new CertificatePolicyId(new ObjectIdentifier(issuerPolicyId)), new CertificatePolicyId(new ObjectIdentifier(subjectPolicyId)));
                    policyMaps.addElement(map);
                }
                ext.set("map", policyMaps);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.PolicyMappings_Id.toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("PolicyMappingsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("PolicyMappingsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        PolicyMappingsExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("policyMappingsCritical")) {
            ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_DOMAINS)) {
            ext = (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            int num_mappings = this.getNumMappings();
            Enumeration maps = ext.getMappings();
            Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
            for (int i = 0; i < num_mappings; ++i) {
                NameValuePairs pairs = new NameValuePairs();
                if (maps.hasMoreElements()) {
                    CertificatePolicyMap map = (CertificatePolicyMap)maps.nextElement();
                    CertificatePolicyId i1 = map.getIssuerIdentifier();
                    CertificatePolicyId s1 = map.getSubjectIdentifier();
                    pairs.put((Object)ISSUER_POLICY_ID, (Object)i1.getIdentifier().toString());
                    pairs.put((Object)SUBJECT_POLICY_ID, (Object)s1.getIdentifier().toString());
                    pairs.put((Object)POLICY_ID_ENABLE, (Object)"true");
                } else {
                    pairs.put((Object)ISSUER_POLICY_ID, (Object)"");
                    pairs.put((Object)SUBJECT_POLICY_ID, (Object)"");
                    pairs.put((Object)POLICY_ID_ENABLE, (Object)"false");
                }
                recs.addElement(pairs);
            }
            return PolicyMappingsExtDefault.buildRecords(recs);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumMappings();
        for (int i = 0; i < num; ++i) {
            sb.append("Record #");
            sb.append(i);
            sb.append("{");
            sb.append("Issuer Policy Id:");
            sb.append(this.getConfig(CONFIG_ISSUER_DOMAIN_POLICY + i));
            sb.append(",");
            sb.append("Subject Policy Id:");
            sb.append(this.getConfig(CONFIG_SUBJECT_DOMAIN_POLICY + i));
            sb.append(",");
            sb.append("Enable:");
            sb.append(this.getConfig(CONFIG_ENABLE + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_POLICY_MAPPINGS_EXT", (String[])new String[]{this.getConfig("policyMappingsCritical"), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        PolicyMappingsExtension ext = this.createExtension();
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.PolicyMappings_Id.toString(), (Extension)ext, info);
    }

    public PolicyMappingsExtension createExtension() {
        PolicyMappingsExtension ext = null;
        try {
            boolean critical = this.getConfigBoolean("policyMappingsCritical");
            Vector<CertificatePolicyMap> policyMaps = new Vector<CertificatePolicyMap>();
            int num = this.getNumMappings();
            for (int i = 0; i < num; ++i) {
                String enable = this.getConfig(CONFIG_ENABLE + i);
                if (enable == null || !enable.equals("true")) continue;
                String issuerID = this.getConfig(CONFIG_ISSUER_DOMAIN_POLICY + i);
                if (issuerID == null || issuerID.length() == 0) {
                    return null;
                }
                String subjectID = this.getConfig(CONFIG_SUBJECT_DOMAIN_POLICY + i);
                if (subjectID == null || subjectID.length() == 0) {
                    return null;
                }
                CertificatePolicyMap map = new CertificatePolicyMap(new CertificatePolicyId(new ObjectIdentifier(issuerID)), new CertificatePolicyId(new ObjectIdentifier(subjectID)));
                policyMaps.addElement(map);
            }
            ext = new PolicyMappingsExtension(critical, policyMaps);
        }
        catch (Exception e) {
            logger.warn("PolicyMappingsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

