/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSAuthorityKeyIdentifierExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSAuthorityKeyIdentifierExtension.class);

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        AuthorityKeyIdentifierExtension authKeyIdExt = null;
        KeyIdentifier keyId = null;
        GeneralNames names = null;
        SerialNumber sn = null;
        try {
            keyId = (KeyIdentifier)((AuthorityKeyIdentifierExtension)ext).get("key_id");
            names = (GeneralNames)((AuthorityKeyIdentifierExtension)ext).get("auth_name");
            sn = (SerialNumber)((AuthorityKeyIdentifierExtension)ext).get("serial_number");
            authKeyIdExt = new AuthorityKeyIdentifierExtension(critical, keyId, names, sn);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AKI_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return authKeyIdExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        AuthorityKeyIdentifierExtension authKeyIdExt = null;
        CRLIssuingPoint crlIssuingPoint = (CRLIssuingPoint)ip;
        try {
            KeyIdentifier keyId = null;
            try {
                CertificateExtensions caCertExtensions;
                X509CertInfo info = (X509CertInfo)crlIssuingPoint.getCertificateAuthority().getCACert().get("x509.info");
                if (info != null && (caCertExtensions = (CertificateExtensions)info.get("extensions")) != null) {
                    for (int i = 0; i < caCertExtensions.size(); ++i) {
                        Extension caCertExt = (Extension)caCertExtensions.elementAt(i);
                        if (!(caCertExt instanceof SubjectKeyIdentifierExtension)) continue;
                        SubjectKeyIdentifierExtension id = (SubjectKeyIdentifierExtension)caCertExt;
                        keyId = (KeyIdentifier)id.get("key_id");
                    }
                }
            }
            catch (CertificateParsingException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CERT_PARSING_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (CertificateException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CERT_CERT_EXCEPTION", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (keyId != null) {
                authKeyIdExt = new AuthorityKeyIdentifierExtension(critical, keyId, null, null);
            } else {
                GeneralNames gNames = new GeneralNames();
                gNames.addElement((Object)crlIssuingPoint.getCertificateAuthority().getX500Name());
                authKeyIdExt = new AuthorityKeyIdentifierExtension(critical, null, gNames, new SerialNumber(crlIssuingPoint.getCertificateAuthority().getCACert().getSerialNumber()));
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AKI_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return authKeyIdExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.AuthorityKey_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Authority Key Identifier CRL extension.", "critical;boolean;Set criticality for Authority Key Identifier CRL extension.", "HELP_TOKEN;configuration-ca-edit-crlextension-authoritykeyidentifier", "HELP_TEXT;The authority key identifier extension provides a means of identifying the public key corresponding to the private key used to sign a CRL."};
        return params;
    }
}

