/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ca.EErrorPublishCRL;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationRequestListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(RevocationRequestListener.class);
    private CRLIssuingPoint crlIssuingPoint;

    public RevocationRequestListener(CRLIssuingPoint crlIssuingPoint) {
        this.crlIssuingPoint = crlIssuingPoint;
    }

    public void init(Subsystem sys, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        String requestType = r.getRequestType();
        if (!(requestType.equals("revocation") || requestType.equals("unrevocation") || requestType.equals("cert4crl") || requestType.equals("uncert4crl"))) {
            return;
        }
        logger.info("RevocationRequestListener: Received revocation request " + r.getRequestId().toHexString());
        if (this.crlIssuingPoint.mBeginSerial != null || this.crlIssuingPoint.mEndSerial != null) {
            int i;
            BigInteger[] serialNumbers = r.getExtDataInBigIntegerArray("OLD_SERIALS");
            if (serialNumbers == null || serialNumbers.length == 0) {
                X509CertImpl[] oldCerts = r.getExtDataInCertArray("OLD_CERTS");
                if (oldCerts == null || oldCerts.length == 0) {
                    return;
                }
                serialNumbers = new BigInteger[oldCerts.length];
                for (i = 0; i < oldCerts.length; ++i) {
                    serialNumbers[i] = oldCerts[i].getSerialNumber();
                }
            }
            logger.debug("RevocationRequestListener: Checking serial numbers:");
            boolean inRange = false;
            for (i = 0; i < serialNumbers.length; ++i) {
                BigInteger serialNumber = serialNumbers[i];
                logger.debug("RevocationRequestListener: - serial number: " + serialNumber);
                if (this.crlIssuingPoint.mBeginSerial != null && serialNumber.compareTo(this.crlIssuingPoint.mBeginSerial) < 0 || this.crlIssuingPoint.mEndSerial != null && serialNumber.compareTo(this.crlIssuingPoint.mEndSerial) > 0) continue;
                inRange = true;
            }
            logger.debug("RevocationRequestListener: Serial numbers in range: " + inRange);
            if (!inRange) {
                return;
            }
        }
        if (this.crlIssuingPoint.mAlwaysUpdate) {
            logger.info("RevocationRequestListener: Updating CRL in " + this.crlIssuingPoint.getId());
            try {
                this.crlIssuingPoint.updateCRLNow();
                r.setExtData(this.crlIssuingPoint.mCrlUpdateStatus, Request.RES_SUCCESS);
                if (this.crlIssuingPoint.mPublisherProcessor != null) {
                    r.setExtData(this.crlIssuingPoint.mCrlPublishStatus, Request.RES_SUCCESS);
                }
            }
            catch (EErrorPublishCRL e) {
                r.setExtData(this.crlIssuingPoint.mCrlUpdateStatus, Request.RES_SUCCESS);
                if (this.crlIssuingPoint.mPublisherProcessor != null) {
                    r.setExtData(this.crlIssuingPoint.mCrlPublishStatus, Request.RES_ERROR);
                    r.setExtData(this.crlIssuingPoint.mCrlPublishError, (Throwable)e);
                }
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_UPDATE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                r.setExtData(this.crlIssuingPoint.mCrlUpdateStatus, Request.RES_ERROR);
                r.setExtData(this.crlIssuingPoint.mCrlUpdateError, (Throwable)e);
            }
            catch (Exception e) {
                String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_UPDATE_CRL", (Object[])new Object[]{e.toString()});
                logger.warn(message, (Throwable)e);
                r.setExtData(this.crlIssuingPoint.mCrlUpdateStatus, Request.RES_ERROR);
                r.setExtData(this.crlIssuingPoint.mCrlUpdateError, (Throwable)new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()})));
            }
        }
    }
}

