/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.common;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.dogtagpki.common.ConfigData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(ConfigClient.class);

    public ConfigClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "config");
    }

    public ConfigData getConfig() throws Exception {
        return this.get(ConfigData.class);
    }

    public ConfigData getConfig(String names, String substores, String sessionID) throws Exception {
        logger.info("Getting configuration properties");
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"op", (Object)"get");
        content.putSingle((Object)"names", (Object)names);
        content.putSingle((Object)"substores", (Object)substores);
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"sessionID", (Object)sessionID);
        String response = this.client.post(this.subsystem + "/admin/" + this.subsystem + "/getConfigEntries", (MultivaluedMap<String, String>)content, String.class);
        logger.debug("Response: " + response);
        if (response == null) {
            throw new IOException("Unable to get configuration properties");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        XMLObject parser = new XMLObject(bis);
        String status = parser.getValue("Status");
        logger.debug("Status: " + status);
        if (status.equals("2")) {
            throw new EAuthException("Authentication failed");
        }
        if (!status.equals("0")) {
            String error = parser.getValue("Error");
            throw new IOException(error);
        }
        logger.info("Properties:");
        HashMap<String, String> properties = new HashMap<String, String>();
        Document doc = parser.getDocument();
        NodeList nameNodes = doc.getElementsByTagName("name");
        int nameCount = nameNodes.getLength();
        for (int i = 0; i < nameCount; ++i) {
            Node nameNode = nameNodes.item(i);
            NodeList nameChildNodes = nameNode.getChildNodes();
            String name = nameChildNodes.item(0).getNodeValue();
            logger.info("- " + name);
            Node parentNode = nameNode.getParentNode();
            NodeList siblingNodes = parentNode.getChildNodes();
            int siblingCount = siblingNodes.getLength();
            String value = "";
            for (int j = 0; j < siblingCount; ++j) {
                Node siblingNode = siblingNodes.item(j);
                String siblingNodeName = siblingNode.getNodeName();
                if (!siblingNodeName.equals("value")) continue;
                NodeList valueNodes = siblingNode.getChildNodes();
                if (valueNodes.getLength() <= 0) break;
                value = valueNodes.item(0).getNodeValue();
                break;
            }
            properties.put(name, value);
        }
        ConfigData config = new ConfigData();
        config.setProperties(properties);
        return config;
    }

    public ConfigData updateConfig(ConfigData configData) throws Exception {
        Entity<ConfigData> entity = this.client.entity(configData);
        return this.patch(null, null, entity, ConfigData.class);
    }
}

