/*
 * Decompiled with CFR 0.152.
 */
package netscape.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import netscape.net.TransferProtocolClient;
import netscape.net.smtp.SmtpPrintStream;
import netscape.net.smtp.SmtpProtocolException;

public class SmtpClient
extends TransferProtocolClient {
    SmtpPrintStream message;

    @Override
    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    void issueCommand(String cmd, int expect) throws IOException {
        int reply;
        this.sendServer(cmd);
        while ((reply = this.readServerResponse()) != expect) {
            if (reply == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }

    private void toCanonical(String s) throws IOException {
        this.issueCommand("rcpt to: " + s + "\r\n", 250);
    }

    public void to(String s) throws IOException {
        int st = 0;
        int limit = s.length();
        int lastnonsp = 0;
        int parendepth = 0;
        boolean ignore = false;
        for (int pos = 0; pos < limit; ++pos) {
            char c = s.charAt(pos);
            if (parendepth > 0) {
                if (c == '(') {
                    ++parendepth;
                } else if (c == ')') {
                    --parendepth;
                }
                if (parendepth != 0) continue;
                if (lastnonsp > st) {
                    ignore = true;
                    continue;
                }
                st = pos + 1;
                continue;
            }
            if (c == '(') {
                ++parendepth;
                continue;
            }
            if (c == '<') {
                st = lastnonsp = pos + 1;
                continue;
            }
            if (c == '>') {
                ignore = true;
                continue;
            }
            if (c == ',') {
                if (lastnonsp > st) {
                    this.toCanonical(s.substring(st, lastnonsp));
                }
                st = pos + 1;
                ignore = false;
                continue;
            }
            if (c > ' ' && !ignore) {
                lastnonsp = pos + 1;
                continue;
            }
            if (st != pos) continue;
            ++st;
        }
        if (lastnonsp > st) {
            this.toCanonical(s.substring(st, lastnonsp));
        }
    }

    public void from(String s) throws IOException {
        this.issueCommand("mail from: " + s + "\r\n", 250);
    }

    private void openServer(String host) throws IOException {
        this.openServer(host, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        return this.message;
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public SmtpClient(String host) throws IOException {
        if (host != null) {
            try {
                this.openServer(host);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String s = System.getProperty("mail.host");
            if (s != null) {
                this.openServer(s);
                return;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            this.openServer("localhost");
        }
        catch (Exception e) {
            this.openServer("mailhost");
        }
    }

    public SmtpClient() throws IOException {
        this(null);
    }
}

