/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.netscape.certsrv.base.PKIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JSONSerializer {
    public static final Logger logger = LoggerFactory.getLogger(JSONSerializer.class);

    default public String toJSON() throws JsonProcessingException {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).deactivateDefaultTyping().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector()).writeValueAsString((Object)this);
    }

    public static <T> T fromJSON(String json, Class<T> clazz) throws JsonProcessingException {
        try {
            return (T)new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector()).deactivateDefaultTyping().readValue(json, clazz);
        }
        catch (JsonParseException e) {
            String errMsg = "The input file provided could not be parsed as JSON";
            logger.debug(errMsg, (Throwable)e);
            throw new PKIException(errMsg);
        }
    }
}

