/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileAttribute
implements JSONSerializer {
    private String name;
    private String value;
    private Descriptor descriptor;

    public ProfileAttribute() {
    }

    public ProfileAttribute(String name, String value, Descriptor descriptor) {
        this.name = name;
        this.value = value;
        this.descriptor = descriptor;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="Value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="Descriptor")
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return "PolicyAttribute [name=" + this.name + ", value=" + this.value + ", descriptor=" + this.descriptor + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileAttribute other = (ProfileAttribute)obj;
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public void toDOM(Document document, Element profileAttributeElement) {
        if (this.name != null) {
            profileAttributeElement.setAttribute("name", this.name);
        }
        if (this.value != null) {
            Element valueElement = document.createElement("Value");
            valueElement.appendChild(document.createTextNode(this.value));
            profileAttributeElement.appendChild(valueElement);
        }
        if (this.descriptor != null) {
            Element descriptorElement = this.descriptor.toDOM(document);
            profileAttributeElement.appendChild(descriptorElement);
        }
    }

    public Element toDOM(Document document) {
        Element attribute = document.createElement("Attribute");
        this.toDOM(document, attribute);
        return attribute;
    }

    public static ProfileAttribute fromDOM(Element profileAttributeElement) {
        NodeList descriptorList;
        ProfileAttribute profileAttribute = new ProfileAttribute();
        String id = profileAttributeElement.getAttribute("name");
        profileAttribute.setName(id);
        NodeList valueList = profileAttributeElement.getElementsByTagName("Value");
        if (valueList.getLength() > 0) {
            String value = valueList.item(0).getTextContent();
            profileAttribute.setValue(value);
        }
        if ((descriptorList = profileAttributeElement.getElementsByTagName("Descriptor")).getLength() > 0) {
            Element descriptorElement = (Element)descriptorList.item(0);
            Descriptor descriptor = Descriptor.fromDOM(descriptorElement);
            profileAttribute.setDescriptor(descriptor);
        }
        return profileAttribute;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element accountElement = this.toDOM(document);
        document.appendChild(accountElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static ProfileAttribute fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element accountElement = document.getDocumentElement();
        return ProfileAttribute.fromDOM(accountElement);
    }
}

