/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.acls.ACLMapping;
import com.netscape.certsrv.authentication.ExternalAuthToken;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.logging.event.AuthzEvent;
import com.netscape.certsrv.logging.event.RoleAssumeEvent;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.logging.Auditor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.catalina.realm.GenericPrincipal;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.spi.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ACLInterceptor
implements ContainerRequestFilter {
    public static Logger logger = LoggerFactory.getLogger(ACLInterceptor.class);
    private static final String LOGGING_ACL_PARSING_ERROR = "internal error: ACL parsing error";
    private static final String LOGGING_NO_ACL_ACCESS_ALLOWED = "no ACL configured; OK";
    private static final String LOGGING_MISSING_AUTH_TOKEN = "auth token not found";
    private static final String LOGGING_MISSING_ACL_MAPPING = "ACL mapping not found; OK";
    private static final String LOGGING_INVALID_ACL_MAPPING = "internal error: invalid ACL mapping";
    Properties properties;
    @Context
    ServletContext servletContext;
    @Context
    SecurityContext securityContext;

    public CMSEngine getCMSEngine() {
        return (CMSEngine)this.servletContext.getAttribute("engine");
    }

    public synchronized void loadProperties() throws IOException {
        if (this.properties != null) {
            return;
        }
        this.properties = new Properties();
        String context = this.servletContext.getContextPath();
        String subsystem = context.startsWith("/") ? context.substring(1) : context;
        String defaultMapping = "/usr/share/pki/" + subsystem + "/conf/acl.properties";
        logger.debug("ACLInterceptor: loading " + defaultMapping);
        try (FileReader in = new FileReader(defaultMapping);){
            this.properties.load(in);
        }
        File customMapping = new File(CMS.getInstanceDir() + "/" + subsystem + "/conf/acl.properties");
        logger.debug("ACLInterceptor: checking " + customMapping);
        if (customMapping.exists()) {
            logger.debug("ACLInterceptor: loading " + customMapping);
            try (FileReader in = new FileReader(customMapping);){
                this.properties.load(in);
            }
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        PKIPrincipal pkiPrincipal;
        CharSequence[] roles;
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        Method method = methodInvoker.getMethod();
        Class clazz = methodInvoker.getResourceClass();
        String auditInfo = clazz.getSimpleName() + "." + method.getName();
        logger.debug("ACLInterceptor: " + auditInfo + "()");
        String auditSubjectID = "$Unidentified$";
        boolean authzRequired = true;
        ACLMapping aclMapping = method.getAnnotation(ACLMapping.class);
        if (aclMapping == null) {
            aclMapping = clazz.getAnnotation(ACLMapping.class);
        }
        if (aclMapping == null) {
            logger.debug("ACLInterceptor.filter: no authorization required");
            authzRequired = false;
        }
        Principal principal = null;
        principal = this.securityContext.getUserPrincipal();
        if (principal == null && authzRequired) {
            logger.debug("ACLInterceptor: No user principal provided.");
            throw new ForbiddenException("No user principal provided.");
        }
        if (principal != null) {
            logger.debug("ACLInterceptor: principal: " + principal.getName());
        }
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        AuthzSubsystem authzSubsystem = engine.getAuthzSubsystem();
        AuthToken authToken = null;
        String authzMgrName = null;
        if (principal != null) {
            if (principal instanceof PKIPrincipal) {
                authzMgrName = "DirAclAuthz";
                authToken = ((PKIPrincipal)((Object)principal)).getAuthToken();
            } else if (principal instanceof GenericPrincipal) {
                String realm = null;
                String[] parts = principal.getName().split("@", 2);
                if (parts.length == 2) {
                    realm = parts[1];
                }
                try {
                    authzMgrName = authzSubsystem.getAuthzManagerNameByRealm(realm);
                }
                catch (EAuthzUnknownRealm e) {
                    throw new ForbiddenException("Cannot find AuthzManager for external principal " + principal.getName(), (Throwable)e);
                }
                authToken = new ExternalAuthToken((GenericPrincipal)principal);
            }
            logger.debug("ACLInterceptor: will use authz manager " + authzMgrName);
        }
        if (authToken == null && authzRequired) {
            logger.debug("ACLInterceptor: No authentication token present.");
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, null, null, "auth token not found:" + auditInfo));
            throw new ForbiddenException("No authorization token present.");
        }
        if (authToken != null) {
            auditSubjectID = authToken.getInString("userid");
        }
        if (!authzRequired) {
            logger.debug("ACLInterceptor: Unprotected resource; access granted");
            auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, null, null, "ACL mapping not found; OK:" + auditInfo));
            return;
        }
        String name = aclMapping.value();
        logger.debug("ACLInterceptor: mapping: " + name);
        String[] values = null;
        String value = null;
        try {
            this.loadProperties();
            value = this.properties.getProperty(name);
        }
        catch (IOException e) {
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, null, null, "internal error: ACL parsing error:" + auditInfo));
            e.printStackTrace();
            throw new Failure((Throwable)e);
        }
        if (value == null) {
            logger.debug("ACLInterceptor: Unprotected resource; access granted");
            auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, null, null, "no ACL configured; OK:" + auditInfo));
            return;
        }
        values = value.split(",");
        if (values.length != 2) {
            logger.error("ACLInterceptor: Invalid ACL mapping: " + value);
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, null, null, "internal error: invalid ACL mapping:" + auditInfo));
            throw new ForbiddenException("Invalid ACL mapping.");
        }
        logger.debug("ACLInterceptor: ACL: " + value);
        try {
            AuthzToken authzToken = authzSubsystem.authorize(authzMgrName, authToken, values[0], values[1]);
            if (authzToken == null) {
                String info = "No authorization token present.";
                logger.debug("ACLInterceptor: " + info);
                auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, values[0], values[1], info));
                throw new ForbiddenException("No authorization token present.");
            }
            logger.debug("ACLInterceptor: access granted");
        }
        catch (EAuthzAccessDenied e) {
            String info = e.getMessage();
            logger.debug("ACLInterceptor: " + info);
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, values[0], values[1], info));
            throw new ForbiddenException(e.toString());
        }
        catch (EBaseException e) {
            String info = e.getMessage();
            logger.error("ACLInterceptor: " + info, (Throwable)e);
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, values[0], values[1], info));
            throw new Failure((Throwable)e);
        }
        logger.debug("ACLInterceptor: Protected resource; access granted");
        auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, values[0], values[1], auditInfo));
        if (principal instanceof PKIPrincipal && (roles = (pkiPrincipal = (PKIPrincipal)((Object)principal)).getRoles()) != null) {
            auditor.log(RoleAssumeEvent.createSuccessEvent(auditSubjectID, String.join((CharSequence)",", roles)));
        }
    }
}

