/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.session;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.SecurityDomainSessionTable;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimer
extends TimerTask {
    public static Logger logger = LoggerFactory.getLogger(SessionTimer.class);
    protected CMSEngine engine;
    private SecurityDomainSessionTable m_sessiontable = null;

    public SessionTimer(SecurityDomainSessionTable table) {
        this.m_sessiontable = table;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (Exception e) {
            logger.warn("SessionTimer: " + e.getMessage(), (Throwable)e);
        }
    }

    public void runImpl() throws Exception {
        logger.info("SessionTimer: checking security domain sessions");
        Auditor auditor = this.engine.getAuditor();
        Enumeration keys = this.m_sessiontable.getSessionIDs();
        while (keys.hasMoreElements()) {
            long timeToLive;
            String sessionId = (String)keys.nextElement();
            long beginTime = this.m_sessiontable.getBeginTime(sessionId);
            Date nowDate = new Date();
            long nowTime = nowDate.getTime();
            if (nowTime - beginTime <= (timeToLive = this.m_sessiontable.getTimeToLive())) continue;
            logger.info("SessionTimer: Removing expired session: " + sessionId);
            String auditParams = "operation;;expire_token+token;;" + sessionId;
            try {
                this.m_sessiontable.removeEntry(sessionId);
                String message = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", "system", "Success", auditParams);
                auditor.log(message);
            }
            catch (Exception e) {
                String message = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SECURITY_DOMAIN_UPDATE_1", "system", "Failure", auditParams);
                auditor.log(message);
                throw new PKIException("Unable to remove expired session: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

