/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.DateMapper;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateArrayMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(DateArrayMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public DateArrayMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        Date[] dates = (Date[])obj;
        logger.debug("DateArrayMapper: Mapping " + name + " to " + this.mLdapName);
        LDAPAttribute attr = new LDAPAttribute(this.mLdapName);
        for (int i = 0; i < dates.length; ++i) {
            attr.addValue(DateMapper.dateToDB(dates[i]));
        }
        attrs.add(attr);
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        Enumeration e = attr.getStringValues();
        Vector<Date> v = new Vector<Date>();
        while (e.hasMoreElements()) {
            v.addElement(DateMapper.dateFromDB((String)e.nextElement()));
        }
        if (v.size() == 0) {
            return;
        }
        Object[] dates = new Date[v.size()];
        v.copyInto(dates);
        parent.set(name, dates);
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

