/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.cmscore.base.ConfigStore;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.mozilla.jss.netscape.security.extensions.CertificateRenewalWindowExtension;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeOfUseExtension;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.FreshestCRLExtension;
import org.mozilla.jss.netscape.security.x509.HoldInstructionExtension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidLoaderSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(OidLoaderSubsystem.class);
    private ConfigStore mConfig;
    public static final String ID = "oidmap";
    private String mId = "oidmap";
    private static final String PROP_OID = "oid";
    private static final String PROP_CLASS = "class";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static final ObjectIdentifier CertType_Id = new ObjectIdentifier(CertType_data);
    private static final String[][] oidMapEntries = new String[][]{{NSCertTypeExtension.class.getName(), CertType_Id.toString(), "NSCertType"}, {CertificateRenewalWindowExtension.class.getName(), CertificateRenewalWindowExtension.ID.toString(), "CertificateRenewalWindow"}, {CertificateScopeOfUseExtension.class.getName(), CertificateScopeOfUseExtension.ID.toString(), "CertificateScopeOfUse"}, {DeltaCRLIndicatorExtension.class.getName(), "2.5.29.27", "DeltaCRLIndicator"}, {HoldInstructionExtension.class.getName(), "2.5.29.23", "HoldInstruction"}, {InvalidityDateExtension.class.getName(), "2.5.29.24", "InvalidityDate"}, {IssuingDistributionPointExtension.class.getName(), "2.5.29.28", "IssuingDistributionPoint"}, {FreshestCRLExtension.class.getName(), "2.5.29.46", "FreshestCRL"}};

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    @Override
    public synchronized void init(ConfigStore config) throws Exception {
        logger.trace("OIDLoaderSubsystem started");
        this.mConfig = config;
        Enumeration<String> names = this.mConfig.getSubStoreNames().elements();
        for (int i = 0; i < oidMapEntries.length; ++i) {
            try {
                OIDMap.addAttribute((String)oidMapEntries[i][0], (String)oidMapEntries[i][1], (String)oidMapEntries[i][2]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (names.hasMoreElements()) {
            String substorename = names.nextElement();
            ConfigStore substore = this.mConfig.getSubStore(substorename, ConfigStore.class);
            try {
                String oidname = substore.getString(PROP_OID);
                String classname = substore.getString(PROP_CLASS);
                OIDMap.addAttribute((String)classname, (String)oidname, (String)substorename);
            }
            catch (EPropertyNotFound ePropertyNotFound) {
            }
            catch (CertificateException certificateException) {}
        }
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public synchronized void shutdown() {
    }

    @Override
    public synchronized ConfigStore getConfigStore() {
        return this.mConfig;
    }
}

