/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.connector;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.connector.IPKIMessage;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.connector.HttpPKIMessage;
import com.netscape.cmscore.connector.HttpRequestEncoder;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(CloneServlet.class);
    private static final long serialVersionUID = -3474557834182380981L;
    public static final String INFO = "Clone Servlet";
    public static final String PROP_AUTHORITY = "authority";
    protected ServletConfig mConfig = null;
    protected IAuthority mAuthority = null;
    protected HttpRequestEncoder mReqEncoder;
    protected AuthSubsystem mAuthSubsystem;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CMSEngine engine = this.getCMSEngine();
        this.mConfig = sc;
        String authority = sc.getInitParameter(PROP_AUTHORITY);
        if (authority != null) {
            this.mAuthority = (IAuthority)((Object)engine.getSubsystem(authority));
        }
        this.mReqEncoder = new HttpRequestEncoder();
        this.mAuthSubsystem = engine.getAuthSubsystem();
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        X509Certificate peerCert;
        CMSEngine engine = this.getCMSEngine();
        boolean running_state = engine.isInRunningState();
        if (!running_state) {
            throw new IOException("CMS server is not ready to serve.");
        }
        CMSRequest cmsRequest = this.newCMSRequest();
        cmsRequest.setHttpParams(new ArgBlock(CloneServlet.toHashtable(req)));
        cmsRequest.setHttpReq(req);
        cmsRequest.setHttpResp(resp);
        cmsRequest.setServletConfig(this.mConfig);
        cmsRequest.setServletContext(this.mConfig.getServletContext());
        char[] content = null;
        String encodedreq = null;
        String method = null;
        int len = -1;
        IPKIMessage msg = null;
        IPKIMessage replymsg = null;
        method = req.getMethod();
        len = req.getContentLength();
        if (len > 0) {
            int done;
            ServletInputStream in = req.getInputStream();
            InputStreamReader inreader = new InputStreamReader((InputStream)in, "UTF8");
            BufferedReader reader = new BufferedReader(inreader, len);
            content = new char[len];
            for (int total = done = reader.read(content, 0, len); done >= 0 && total < len; total += done) {
                done = reader.read(content, total, len - total);
            }
            reader.close();
            encodedreq = new String(content);
        }
        try {
            peerCert = this.getPeerCert(req);
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSGW_HAS_NO_CLIENT_CERT", new Object[0]), (Throwable)e);
            resp.sendError(401);
            return;
        }
        if (peerCert == null) {
            resp.sendError(403);
            return;
        }
        String CCA_Id = null;
        String CCAUserId = null;
        AuthToken token = null;
        try {
            logger.debug("CloneServlet: about to authenticate");
            token = this.authenticate(peerCert);
            CCAUserId = token.getInString("userid");
            CCA_Id = peerCert.getSubjectDN().toString();
        }
        catch (EInvalidCredentials e) {
            resp.sendError(401);
            return;
        }
        catch (EBaseException e) {
            resp.sendError(403);
            return;
        }
        logger.info("CloneServlet: Clone Certificate Authority authenticated: " + peerCert.getSubjectDN());
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, token, this.mAuthzResourceName, "submit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsRequest.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        if (!method.equalsIgnoreCase("POST")) {
            resp.sendError(405);
            return;
        }
        if (len <= 0) {
            resp.sendError(411);
            return;
        }
        try {
            logger.debug("Cloneservlet: before decoding request, encodedreq= " + encodedreq);
            msg = (IPKIMessage)this.mReqEncoder.decode(encodedreq);
            logger.debug("Cloneservlet: decoded request");
            replymsg = this.processRequest(CCA_Id, CCAUserId, msg, token);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_IO_ERROR_REMOTE_REQUEST", e.toString()), (Throwable)e);
            resp.sendError(400);
            return;
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSGW_IO_ERROR_REMOTE_REQUEST", e.toString()), (Throwable)e);
            resp.sendError(500);
            return;
        }
        String encodedrep = this.mReqEncoder.encode(replymsg);
        resp.setStatus(200);
        resp.setContentType("text/html");
        resp.setContentLength(encodedrep.length());
        ServletOutputStream out = resp.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
        writer.write(encodedrep);
        writer.flush();
        writer.close();
        out.flush();
    }

    protected AuthToken authenticate(X509Certificate peerCert) throws EBaseException {
        try {
            X509CertImpl cert = new X509CertImpl(peerCert.getEncoded());
            AuthCredentials creds = new AuthCredentials();
            creds.set("sslClientCert", new X509Certificate[]{cert});
            AuthToken token = this.mAuthSubsystem.authenticate(creds, "certUserDBAuthMgr");
            return token;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_REMOTE_AUTHORITY_AUTH_FAILURE", peerCert.getSubjectDN().toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", e.toString()), (Throwable)e);
        }
        catch (EInvalidCredentials e) {
            logger.error(CMS.getLogMessage("CMSGW_REMOTE_AUTHORITY_AUTH_FAILURE", peerCert.getSubjectDN().toString()), (Throwable)e);
            throw e;
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("CMSGW_REMOTE_AUTHORITY_AUTH_FAILURE", peerCert.getSubjectDN().toString()), (Throwable)e);
            throw e;
        }
    }

    protected IPKIMessage processRequest(String source, String sourceUserId, IPKIMessage msg, AuthToken token) throws EBaseException {
        HttpPKIMessage replymsg = null;
        CMSEngine engine = this.getCMSEngine();
        RequestRepository requestRepository = engine.getRequestRepository();
        RequestQueue queue = engine.getRequestQueue();
        String srcid = source + ":" + msg.getReqId();
        logger.info("CloneServlet: processRequest");
        RequestId thisreqid = queue.findRequestBySourceId(srcid);
        Request thisreq = null;
        if (thisreqid != null) {
            thisreq = requestRepository.readRequest(thisreqid);
            if (thisreq == null) {
                String errormsg = "Cannot find request in request queue " + thisreqid;
                logger.error("CloneServlet: " + errormsg);
                throw new EBaseException(errormsg);
            }
            logger.info("CloneServlet: Found request " + thisreqid + " for " + srcid);
            replymsg = new HttpPKIMessage();
            replymsg.fromRequest(thisreq);
            return replymsg;
        }
        thisreq = requestRepository.createRequest(msg.getReqType());
        thisreq.setSourceId(srcid);
        msg.toRequest(thisreq);
        thisreq.setExtData("AUTH_TOKEN", token);
        thisreq.setExtData("requestorType", "RA");
        logger.info("CloneServlet: Processing remote request " + srcid);
        SessionContext s = SessionContext.getContext();
        if (s.get((Object)"userid") == null) {
            s.put((Object)"userid", (Object)sourceUserId);
        }
        queue.processRequest(thisreq);
        replymsg = new HttpPKIMessage();
        replymsg.fromRequest(thisreq);
        String agentID = sourceUserId;
        String initiative = "fromRemoteAuthority trustedManagerID: " + agentID + " remote reqID " + msg.getReqId();
        String authMgr = "noAuthManager";
        if (token != null) {
            authMgr = token.getInString("authMgrInstName");
        }
        X509CertInfo[] certInfo = thisreq.getExtDataInCertInfoArray("CERT_INFO");
        try {
            if (!thisreq.getRequestStatus().equals((Object)RequestStatus.COMPLETE)) {
                if (certInfo != null) {
                    for (int i = 0; i < certInfo.length; ++i) {
                        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, thisreq.getRequestStatus(), certInfo[i].get("subject"), ""});
                    }
                } else {
                    logger.info("{} reqID {} {} authenticated by {} is {}", new Object[]{thisreq.getRequestType(), thisreq.getRequestId(), initiative, authMgr, thisreq.getRequestStatus()});
                }
            } else if (thisreq.getRequestType().equals("cert4crl")) {
                Integer result = thisreq.getExtDataInInteger("Result");
                if (result.equals(Request.RES_ERROR)) {
                    logger.debug("CloneServlet: error in CLA_CERT4CRL_REQUEST");
                } else {
                    logger.debug("CloneServlet: success in CLA_CERT4CRL_REQUEST");
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return replymsg;
    }

    protected X509Certificate getPeerCert(HttpServletRequest req) throws EBaseException {
        return this.getSSLClientCertificate(req);
    }

    public String getServletInfo() {
        return INFO;
    }
}

