/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CMSRequest {
    private static final String RESULT = "cmsRequestResult";
    public static final Integer UNAUTHORIZED = 1;
    public static final Integer SUCCESS = 2;
    public static final Integer PENDING = 3;
    public static final Integer SVC_PENDING = 4;
    public static final Integer REJECTED = 5;
    public static final Integer ERROR = 6;
    public static final Integer EXCEPTION = 7;
    private String reason = null;
    private ArgBlock mHttpParams;
    private HttpServletRequest mHttpReq = null;
    private HttpServletResponse mHttpResp = null;
    private ServletConfig mServletConfig = null;
    private ServletContext mServletContext = null;
    private Request mRequest = null;
    private Integer mStatus = SUCCESS;
    private String mError = null;
    private Vector<String> mErrorDescr = null;
    Object mResult = null;
    Hashtable<String, Object> mResults = new Hashtable();

    public void setHttpParams(ArgBlock httpParams) {
        this.mHttpParams = httpParams;
    }

    public void setRequest(Request request) {
        this.mRequest = request;
    }

    public void setHttpReq(HttpServletRequest httpReq) {
        this.mHttpReq = httpReq;
    }

    public void setHttpResp(HttpServletResponse httpResp) {
        this.mHttpResp = httpResp;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.mServletConfig = servletConfig;
    }

    public void setServletContext(ServletContext servletContext) {
        this.mServletContext = servletContext;
    }

    public void setStatus(Integer status) {
        if (!(status.equals(UNAUTHORIZED) || status.equals(SUCCESS) || status.equals(REJECTED) || status.equals(PENDING) || status.equals(ERROR) || status.equals(SVC_PENDING) || status.equals(EXCEPTION))) {
            throw new IllegalArgumentException(CMS.getLogMessage("CMSGW_BAD_REQ_STATUS", new Object[0]));
        }
        this.mStatus = status;
    }

    public void setError(EBaseException error) {
        this.mError = error.toString();
    }

    public void setError(String error) {
        this.mError = error;
    }

    public void setErrorDescription(String descr) {
        if (this.mErrorDescr == null) {
            this.mErrorDescr = new Vector();
        }
        this.mErrorDescr.addElement(descr);
    }

    public void setResult(Object result) {
        this.mResult = result;
        this.mResults.put(RESULT, result);
    }

    public void setResult(String name, Object result) {
        this.mResults.put(name, result);
    }

    public ArgBlock getHttpParams() {
        return this.mHttpParams;
    }

    public HttpServletRequest getHttpReq() {
        return this.mHttpReq;
    }

    public HttpServletResponse getHttpResp() {
        return this.mHttpResp;
    }

    public ServletConfig getServletConfig() {
        return this.mServletConfig;
    }

    public ServletContext getServletContext() {
        return this.mServletContext;
    }

    public Request getRequest() {
        return this.mRequest;
    }

    public Integer getStatus() {
        return this.mStatus;
    }

    public String getError() {
        return this.mError;
    }

    public Vector<String> getErrorDescr() {
        return this.mErrorDescr;
    }

    public Object getResult() {
        return this.mResult;
    }

    public Object getResult(String name) {
        return this.mResults.get(name);
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public void setExtData(String type, String value) {
        if (this.mRequest != null) {
            this.mRequest.setExtData(type, value);
        }
    }

    public String getExtData(String type) {
        return this.mRequest == null ? null : this.mRequest.getExtDataInString(type);
    }

    public Vector<String> getPolicyMessages() {
        if (this.mRequest != null) {
            return this.mRequest.getExtDataInStringVector("errors");
        }
        return null;
    }

    public void setIRequestStatus() throws EBaseException {
        if (this.mRequest == null) {
            ECMSGWException e = new ECMSGWException(CMS.getLogMessage("CMSGW_MISSING_REQUEST", new Object[0]));
            throw e;
        }
        RequestStatus status = this.mRequest.getRequestStatus();
        if (status == RequestStatus.COMPLETE) {
            this.mStatus = SUCCESS;
            return;
        }
        if (status == RequestStatus.REJECTED) {
            this.mStatus = REJECTED;
            return;
        }
        if (status == RequestStatus.PENDING) {
            this.mStatus = PENDING;
            return;
        }
        if (status == RequestStatus.SVC_PENDING) {
            this.mStatus = SVC_PENDING;
            return;
        }
        RequestId reqId = this.mRequest.getRequestId();
        throw new ECMSGWException(CMS.getLogMessage("CMSGW_UNEXPECTED_REQUEST_STATUS_2", status.toString(), reqId.toString()));
    }
}

