/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayHtmlServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(DisplayHtmlServlet.class);
    private static final long serialVersionUID = -4343458180370708327L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_HTML_PATH = "htmlPath";
    private String mHTMLPath = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mHTMLPath = sc.getInitParameter(PROP_HTML_PATH);
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("DisplayHtmlServlet about to service ");
        this.authenticate(cmsReq);
        try {
            String realpath = this.servletContext.getRealPath("/" + this.mHTMLPath);
            if (realpath == null) {
                logger.error(CMS.getLogMessage("CMSGW_NO_FIND_TEMPLATE", this.mHTMLPath));
                throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_DISPLAY_TEMPLATE", new Object[0]));
            }
            File file = new File(realpath);
            long flen = file.length();
            byte[] bin = new byte[(int)flen];
            FileInputStream ins = new FileInputStream(file);
            int len = 0;
            if (ins.available() > 0) {
                len = ins.read(bin);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(bin, 0, len);
            bos.writeTo((OutputStream)cmsReq.getHttpResp().getOutputStream());
            ins.close();
            bos.close();
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_OUT_TEMPLATE", this.mHTMLPath, e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_DISPLAY_TEMPLATE", new Object[0]), e);
        }
    }
}

