/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.jss.tomcat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.TLSClientHelloExtractor;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;
import org.dogtagpki.jss.tomcat.JSSNioEndpoint;
import org.mozilla.jss.ssl.javax.JSSSession;

public class JSSSecureNioChannel
extends SecureNioChannel {
    private static final Log log = LogFactory.getLog(JSSSecureNioChannel.class);
    private static final StringManager sm = StringManager.getManager(JSSSecureNioChannel.class);
    private final JSSNioEndpoint endpoint;
    private final Map<String, List<String>> additionalTlsAttributes = new HashMap<String, List<String>>();

    public JSSSecureNioChannel(SocketBufferHandler bufHandler, NioEndpoint endpoint) {
        super(bufHandler, endpoint);
        this.endpoint = (JSSNioEndpoint)endpoint;
    }

    public int handshake(boolean read, boolean write) throws IOException {
        if (this.handshakeComplete) {
            return 0;
        }
        if (!this.sniComplete) {
            int sniResult = this.processJSSSNI();
            if (sniResult == 0) {
                this.sniComplete = true;
            } else {
                return sniResult;
            }
        }
        if (!this.flush(this.netOutBuffer)) {
            return 4;
        }
        SSLEngineResult handshake = null;
        block9: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException(sm.getString("channel.nio.ssl.notHandshaking"));
                }
                case FINISHED: {
                    if (this.endpoint.hasNegotiableProtocols()) {
                        if (this.sslEngine instanceof SSLUtil.ProtocolInfo) {
                            this.socketWrapper.setNegotiatedProtocol(((SSLUtil.ProtocolInfo)this.sslEngine).getNegotiatedProtocol());
                        } else if (JreCompat.isAlpnSupported()) {
                            this.socketWrapper.setNegotiatedProtocol(JreCompat.getInstance().getApplicationProtocol(this.sslEngine));
                        }
                    }
                    this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    return this.handshakeComplete ? 0 : 4;
                }
                case NEED_WRAP: {
                    try {
                        handshake = this.handshakeWrap(write);
                    }
                    catch (SSLException e) {
                        handshake = this.handshakeWrap(write);
                        throw e;
                    }
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.handshakeStatus = this.tasks();
                        }
                    } else {
                        if (handshake.getStatus() == SSLEngineResult.Status.CLOSED) {
                            this.flush(this.netOutBuffer);
                            return -1;
                        }
                        throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringWrap", new Object[]{handshake.getStatus()}));
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.flush(this.netOutBuffer)) {
                        return 4;
                    }
                }
                case NEED_UNWRAP: {
                    handshake = this.handshakeUnwrap(read);
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block9;
                        this.handshakeStatus = this.tasks();
                        continue block9;
                    }
                    if (handshake.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return 1;
                    }
                    throw new IOException(sm.getString("channel.nio.ssl.unexpectedStatusDuringWrap", new Object[]{handshake.getStatus()}));
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    continue block9;
                }
            }
            throw new IllegalStateException(sm.getString("channel.nio.ssl.invalidStatus", new Object[]{this.handshakeStatus}));
        }
        return 0;
    }

    private int processJSSSNI() throws IOException {
        int bytesRead = this.sc.read(this.netInBuffer);
        if (bytesRead == -1) {
            return -1;
        }
        TLSClientHelloExtractor extractor = new TLSClientHelloExtractor(this.netInBuffer);
        while (extractor.getResult() == TLSClientHelloExtractor.ExtractorResult.UNDERFLOW && this.netInBuffer.capacity() < this.endpoint.getSniParseLimit()) {
            int newLimit = Math.min(this.netInBuffer.capacity() * 2, this.endpoint.getSniParseLimit());
            log.info((Object)sm.getString("channel.nio.ssl.expandNetInBuffer", new Object[]{Integer.toString(newLimit)}));
            this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)newLimit);
            this.sc.read(this.netInBuffer);
            extractor = new TLSClientHelloExtractor(this.netInBuffer);
        }
        String hostName = null;
        List<Cipher> clientRequestedCiphers = null;
        List clientRequestedApplicationProtocols = null;
        switch (extractor.getResult()) {
            case COMPLETE: {
                hostName = extractor.getSNIValue();
                clientRequestedApplicationProtocols = extractor.getClientRequestedApplicationProtocols();
            }
            case NOT_PRESENT: {
                clientRequestedCiphers = extractor.getClientRequestedCiphers();
                break;
            }
            case NEED_READ: {
                return 1;
            }
            case UNDERFLOW: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("channel.nio.ssl.sniDefault"));
                }
                hostName = this.endpoint.getDefaultSSLHostConfigName();
                clientRequestedCiphers = Collections.emptyList();
                break;
            }
            case NON_SECURE: {
                this.netOutBuffer.clear();
                this.netOutBuffer.put(TLSClientHelloExtractor.USE_TLS_RESPONSE);
                this.netOutBuffer.flip();
                this.flushOutbound();
                throw new IOException(sm.getString("channel.nio.ssl.foundHttp"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("channel.nio.ssl.sniHostName", new Object[]{this.sc, hostName}));
        }
        this.sslEngine = this.endpoint.createSSLEngine(hostName, clientRequestedCiphers, clientRequestedApplicationProtocols);
        JSSSession jsession = (JSSSession)this.sslEngine.getSession();
        jsession.setLocalAddr(this.socketWrapper.getLocalAddr());
        jsession.setRemoteAddr(this.socketWrapper.getRemoteAddr());
        this.additionalTlsAttributes.put("org.apache.tomcat.util.net.secure_requested_protocol_versions", extractor.getClientRequestedProtocols());
        this.additionalTlsAttributes.put("org.apache.tomcat.util.net.secure_requested_ciphers", extractor.getClientRequestedCipherNames());
        this.getBufHandler().expand(this.sslEngine.getSession().getApplicationBufferSize());
        if (this.netOutBuffer.capacity() < this.sslEngine.getSession().getApplicationBufferSize()) {
            log.info((Object)sm.getString("channel.nio.ssl.expandNetOutBuffer", new Object[]{Integer.toString(this.sslEngine.getSession().getApplicationBufferSize())}));
        }
        this.netInBuffer = ByteBufferUtils.expand((ByteBuffer)this.netInBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer = ByteBufferUtils.expand((ByteBuffer)this.netOutBuffer, (int)this.sslEngine.getSession().getPacketBufferSize());
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        return 0;
    }

    public SSLSupport getSSLSupport() {
        if (this.sslEngine != null) {
            SSLSession session = this.sslEngine.getSession();
            return this.endpoint.getSslImplementation().getSSLSupport(session, this.additionalTlsAttributes);
        }
        return null;
    }
}

