/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.DisplayText;

public class NoticeReference
implements Serializable {
    private static final long serialVersionUID = 1986080941078808200L;
    private DisplayText mOrg = null;
    private int[] mNumbers = null;

    public NoticeReference(DisplayText org, int[] numbers) {
        this.mOrg = org;
        this.mNumbers = numbers;
    }

    public NoticeReference(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for NoticeReference");
        }
        this.mOrg = new DisplayText(val.data.getDerValue());
        DerValue integers = val.data.getDerValue();
        if (integers.tag != 48) {
            throw new IOException("Invalid encoding for NoticeReference (integers)");
        }
        Vector<BigInt> num = new Vector<BigInt>();
        while (integers.data.available() != 0) {
            DerValue i = integers.data.getDerValue();
            BigInt bigI = i.getInteger();
            num.addElement(bigI);
        }
        if (num.size() <= 0) {
            return;
        }
        this.mNumbers = new int[num.size()];
        for (int i = 0; i < num.size(); ++i) {
            this.mNumbers[i] = ((BigInt)num.elementAt(i)).toInt();
        }
    }

    public DisplayText getOrganization() {
        return this.mOrg;
    }

    public int[] getNumbers() {
        return this.mNumbers;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.mOrg.encode(tmp);
        DerOutputStream iseq = new DerOutputStream();
        for (int i = 0; i < this.mNumbers.length; ++i) {
            iseq.putInteger(new BigInt(this.mNumbers[i]));
        }
        tmp.write((byte)48, iseq);
        out.write((byte)48, tmp);
    }
}

