/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class IssuingDistributionPoint
implements ASN1Value {
    private GeneralNames fullName = null;
    private RDN relativeName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private BitArray onlySomeReasons = null;
    private boolean indirectCRL = false;
    private ANY fullNameEncoding;
    private static final Tag TAG = SEQUENCE.TAG;

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void setFullName(GeneralNames fullName) throws GeneralNamesException, IOException {
        this.fullName = fullName;
        if (fullName != null) {
            DerOutputStream derOut = new DerOutputStream();
            fullName.encode(derOut);
            try {
                ANY raw = new ANY(derOut.toByteArray());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(0L), bos);
                this.fullNameEncoding = new ANY(bos.toByteArray());
            }
            catch (InvalidBERException e) {
                throw new GeneralNamesException(e.toString());
            }
            this.relativeName = null;
        }
    }

    public void setRelativeName(RDN relativeName) {
        this.relativeName = relativeName;
        if (relativeName != null) {
            this.fullName = null;
        }
    }

    public boolean getOnlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public void setOnlyContainsUserCerts(boolean b) {
        this.onlyContainsUserCerts = b;
    }

    public boolean getOnlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public void setOnlyContainsCACerts(boolean b) {
        this.onlyContainsCACerts = b;
    }

    public BitArray getOnlySomeReasons() {
        return this.onlySomeReasons;
    }

    public void setOnlySomeReasons(BitArray reasons) {
        this.onlySomeReasons = reasons;
    }

    public boolean getIndirectCRL() {
        return this.indirectCRL;
    }

    public void setIndirectCRL(boolean b) {
        this.indirectCRL = b;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        try {
            ByteArrayOutputStream bos;
            ANY raw;
            DerOutputStream derOut;
            if (this.fullName != null) {
                EXPLICIT distPoint = new EXPLICIT(Tag.get(0L), this.fullNameEncoding);
                seq.addElement(distPoint);
            } else if (this.relativeName != null) {
                derOut = new DerOutputStream();
                this.relativeName.encode(derOut);
                raw = new ANY(derOut.toByteArray());
                bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(1L), bos);
                ANY distPointName = new ANY(bos.toByteArray());
                EXPLICIT distPoint = new EXPLICIT(Tag.get(0L), distPointName);
                seq.addElement(distPoint);
            }
            if (this.onlyContainsUserCerts) {
                seq.addElement(Tag.get(1L), new BOOLEAN(true));
            }
            if (this.onlyContainsCACerts) {
                seq.addElement(Tag.get(2L), new BOOLEAN(true));
            }
            if (this.onlySomeReasons != null) {
                derOut = new DerOutputStream();
                derOut.putUnalignedBitString(this.onlySomeReasons);
                raw = new ANY(derOut.toByteArray());
                bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(3L), bos);
                ANY reasonEncoding = new ANY(bos.toByteArray());
                seq.addElement(reasonEncoding);
            }
            if (this.indirectCRL) {
                seq.addElement(Tag.get(4L), new BOOLEAN(true));
            }
            seq.encode(implicitTag, ostream);
        }
        catch (InvalidBERException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FilterOutputStream bos = null;
        try {
            if (args.length != 1) {
                System.out.println("Usage: IssuingDistributionPoint <outfile>");
                System.exit(-1);
            }
            bos = new BufferedOutputStream(new FileOutputStream(args[0]));
            SEQUENCE idps = new SEQUENCE();
            IssuingDistributionPoint idp = new IssuingDistributionPoint();
            X500Name dn = new X500Name("CN=Skovw Wjasldk,E=nicolson@netscape.com,OU=Certificate Server,O=Netscape,C=US");
            GeneralNames generalNames = new GeneralNames();
            generalNames.addElement(dn);
            idp.setFullName(generalNames);
            idps.addElement(idp);
            idp = new IssuingDistributionPoint();
            URIName uri = new URIName("http://www.mycrl.com/go/here");
            generalNames = new GeneralNames();
            generalNames.addElement(uri);
            idp.setFullName(generalNames);
            idp.setOnlyContainsUserCerts(true);
            idp.setOnlyContainsCACerts(true);
            idp.setIndirectCRL(true);
            BitArray ba = new BitArray(5, new byte[]{40});
            idp.setOnlySomeReasons(ba);
            idps.addElement(idp);
            idps.encode(bos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

