/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class CertificateIssuerExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 8643788952936025986L;
    public static final String NAME = "CertificateIssuer";
    public static final String CERTIFICATE_ISSUER = "value";
    public static final String OID = "2.5.29.29";
    GeneralNames names = null;

    private void encodeThis() throws IOException {
        DerOutputStream os = new DerOutputStream();
        try {
            this.names.encode(os);
        }
        catch (GeneralNamesException e) {
            throw new IOException(e);
        }
        this.extensionValue = os.toByteArray();
    }

    public CertificateIssuerExtension(Boolean critical, GeneralNames names) throws IOException {
        this.names = names;
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public CertificateIssuerExtension(GeneralNames names) throws IOException {
        this.names = names;
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = true;
        this.encodeThis();
    }

    public CertificateIssuerExtension() {
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = false;
        this.names = new GeneralNames();
    }

    public CertificateIssuerExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        try {
            this.names = new GeneralNames(val);
        }
        catch (GeneralNamesException e) {
            throw new IOException("CertificateIssuerExtension: " + e, e);
        }
    }

    @Override
    public String toString() {
        if (this.names == null) {
            return "";
        }
        String s = super.toString() + "CertificateIssuerName [\n" + this.names.toString() + "]\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificateIssuer_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(CERTIFICATE_ISSUER)) {
            if (!(obj instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.names = (GeneralNames)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(CERTIFICATE_ISSUER)) {
            return this.names;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(CERTIFICATE_ISSUER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.names = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(CERTIFICATE_ISSUER);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            OIDMap.addAttribute(CertificateIssuerExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

