/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.CipherContextProxy;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;

public final class PK11Cipher
extends Cipher
implements AutoCloseable {
    private PK11Token token;
    private EncryptionAlgorithm algorithm;
    private AlgorithmParameterSpec parameters = null;
    private SymmetricKey key = null;
    private byte[] IV = null;
    private CipherContextProxy contextProxy = null;
    private int state = 0;
    private static final int UNINITIALIZED = 0;
    private static final int ENCRYPT = 1;
    private static final int DECRYPT = 2;

    private PK11Cipher() {
    }

    PK11Cipher(PK11Token token, EncryptionAlgorithm algorithm) {
        this.token = token;
        this.algorithm = algorithm;
    }

    @Override
    public void initEncrypt(SymmetricKey key) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.initEncrypt(key, null);
    }

    @Override
    public void initDecrypt(SymmetricKey key) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.initDecrypt(key, null);
    }

    private static byte[] getIVFromParams(AlgorithmParameterSpec params) {
        byte[] IV = null;
        if (params instanceof IVParameterSpec) {
            IV = ((IVParameterSpec)params).getIV();
        } else if (params instanceof IvParameterSpec) {
            IV = ((IvParameterSpec)params).getIV();
        } else if (params instanceof RC2ParameterSpec) {
            IV = ((RC2ParameterSpec)params).getIV();
        }
        return IV;
    }

    @Override
    @Deprecated
    public void initEncrypt(SymmetricKey key, AlgorithmParameterSpec parameters) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.reset();
        this.checkKey(key);
        this.checkParams(parameters);
        this.IV = PK11Cipher.getIVFromParams(parameters);
        this.key = key;
        this.parameters = parameters;
        this.state = 1;
        this.contextProxy = parameters instanceof RC2ParameterSpec ? PK11Cipher.initContextWithKeyBits(true, key, this.algorithm, this.IV, ((RC2ParameterSpec)parameters).getEffectiveKeyBits(), this.algorithm.isPadded()) : PK11Cipher.initContext(true, key, this.algorithm, this.IV, this.algorithm.isPadded());
    }

    @Override
    @Deprecated
    public void initDecrypt(SymmetricKey key, AlgorithmParameterSpec parameters) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.reset();
        this.checkKey(key);
        this.checkParams(parameters);
        this.IV = PK11Cipher.getIVFromParams(parameters);
        this.key = key;
        this.parameters = parameters;
        this.state = 2;
        this.contextProxy = parameters instanceof RC2ParameterSpec ? PK11Cipher.initContextWithKeyBits(false, key, this.algorithm, this.IV, ((RC2ParameterSpec)parameters).getEffectiveKeyBits(), this.algorithm.isPadded()) : PK11Cipher.initContext(false, key, this.algorithm, this.IV, this.algorithm.isPadded());
    }

    @Override
    public byte[] update(byte[] bytes) throws IllegalStateException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        return PK11Cipher.updateContext(this.contextProxy, bytes, this.algorithm.getBlockSize());
    }

    @Override
    public byte[] update(byte[] bytes, int offset, int length) throws IllegalStateException, TokenException {
        byte[] sub = new byte[length];
        System.arraycopy(bytes, offset, sub, 0, length);
        return this.update(sub);
    }

    @Override
    @Deprecated
    public byte[] doFinal(byte[] bytes) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        byte[] first = this.update(bytes);
        byte[] last = PK11Cipher.finalizeContext(this.contextProxy, this.algorithm.getBlockSize(), this.algorithm.isPadded());
        byte[] combined = new byte[first.length + last.length];
        System.arraycopy(first, 0, combined, 0, first.length);
        System.arraycopy(last, 0, combined, first.length, last.length);
        return combined;
    }

    @Override
    public byte[] doFinal(byte[] bytes, int offset, int length) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        byte[] sub = new byte[length];
        System.arraycopy(bytes, offset, sub, 0, length);
        return this.doFinal(sub);
    }

    @Override
    @Deprecated
    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        return PK11Cipher.finalizeContext(this.contextProxy, this.algorithm.getBlockSize(), this.algorithm.isPadded());
    }

    private static native CipherContextProxy initContext(boolean var0, SymmetricKey var1, EncryptionAlgorithm var2, byte[] var3, boolean var4) throws TokenException;

    private static native CipherContextProxy initContextWithKeyBits(boolean var0, SymmetricKey var1, EncryptionAlgorithm var2, byte[] var3, int var4, boolean var5) throws TokenException;

    private static native byte[] updateContext(CipherContextProxy var0, byte[] var1, int var2) throws TokenException;

    private static native byte[] finalizeContext(CipherContextProxy var0, int var1, boolean var2) throws TokenException, IllegalBlockSizeException, BadPaddingException;

    private void reset() {
        this.parameters = null;
        this.key = null;
        this.IV = null;
        this.state = 0;
        this.contextProxy = null;
    }

    private void checkParams(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!this.algorithm.isValidParameterObject(params)) {
            String name = "null";
            if (params != null) {
                name = params.getClass().getName();
            }
            throw new InvalidAlgorithmParameterException(this.algorithm + " cannot use a " + name + " parameter");
        }
    }

    private void checkKey(SymmetricKey key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key is null");
        }
        if (!(key instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        try {
            KeyType keyType = ((PK11SymKey)key).getKeyType();
            if (keyType != KeyType.GENERIC_SECRET && keyType != KeyType.getKeyTypeFromAlgorithm(this.algorithm)) {
                throw new InvalidKeyException("Key is not the right type for this algorithm. Got: " + ((PK11SymKey)key).getKeyType() + " Expected: " + KeyType.getKeyTypeFromAlgorithm(this.algorithm));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unknown algorithm: " + this.algorithm, e);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws Exception {
        if (this.contextProxy != null) {
            try {
                this.contextProxy.close();
            }
            finally {
                this.contextProxy = null;
            }
        }
    }
}

