/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.util.Arrays;
import org.mozilla.jss.crypto.KBKDFDataParameter;

public class KBKDFByteArrayParam
extends KBKDFDataParameter {
    private byte[] data;

    public KBKDFByteArrayParam() {
        super(4L);
    }

    public KBKDFByteArrayParam(byte[] data) throws IllegalArgumentException {
        this();
        this.setByteArray(data);
    }

    public void setByteArray(byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Expected non-null byte array!");
        }
        this.data = Arrays.copyOf(data, data.length);
    }

    public void zeroByteArray() {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    @Override
    protected void acquireNativeResources() throws Exception {
        if (this.data == null || this.data.length == 0) {
            Object msg = "Expected non-null byte array in ";
            msg = (String)msg + "KBKDFByteArrayParam but was null! Call setByteArray ";
            msg = (String)msg + "to provide a byte array.";
            throw new RuntimeException((String)msg);
        }
        this.acquireNativeResourcesInternal();
    }

    @Override
    protected void releaseNativeResources() throws Exception {
        this.releaseNativeResourcesInternal();
    }

    private native void acquireNativeResourcesInternal() throws Exception;

    private native void releaseNativeResourcesInternal() throws Exception;
}

