// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +experimental-zbt -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBT

// RV64ZBT-LABEL: @fsl(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    store i32 [[RS3:%.*]], i32* [[RS3_ADDR]], align 4
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV:%.*]] = sext i32 [[TMP0]] to i64
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// RV64ZBT-NEXT:    [[TMP2:%.*]] = load i32, i32* [[RS3_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV2:%.*]] = sext i32 [[TMP2]] to i64
// RV64ZBT-NEXT:    [[TMP3:%.*]] = call i64 @llvm.riscv.fsl.i64(i64 [[CONV]], i64 [[CONV1]], i64 [[CONV2]])
// RV64ZBT-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP3]] to i32
// RV64ZBT-NEXT:    ret i32 [[CONV3]]
//
int fsl(int rs1, int rs2, int rs3) {
  return __builtin_riscv_fsl_32(rs1, rs2, rs3);
}

// RV64ZBT-LABEL: @fsr(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    store i32 [[RS3:%.*]], i32* [[RS3_ADDR]], align 4
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV:%.*]] = sext i32 [[TMP0]] to i64
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// RV64ZBT-NEXT:    [[TMP2:%.*]] = load i32, i32* [[RS3_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV2:%.*]] = sext i32 [[TMP2]] to i64
// RV64ZBT-NEXT:    [[TMP3:%.*]] = call i64 @llvm.riscv.fsr.i64(i64 [[CONV]], i64 [[CONV1]], i64 [[CONV2]])
// RV64ZBT-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP3]] to i32
// RV64ZBT-NEXT:    ret i32 [[CONV3]]
//
int fsr(int rs1, int rs2, int rs3) {
  return __builtin_riscv_fsr_32(rs1, rs2, rs3);
}

// RV64ZBT-LABEL: @fsri(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV64ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV:%.*]] = sext i32 [[TMP0]] to i64
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV64ZBT-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP1]] to i64
// RV64ZBT-NEXT:    [[TMP2:%.*]] = call i64 @llvm.riscv.fsr.i64(i64 [[CONV]], i64 [[CONV1]], i64 15)
// RV64ZBT-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP2]] to i32
// RV64ZBT-NEXT:    ret i32 [[CONV2]]
//
int fsri(int rs1, int rs2) {
  return __builtin_riscv_fsr_32(rs1, rs2, 15);
}

// RV64ZBT-LABEL: @fslw(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    store i64 [[RS1:%.*]], i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    store i64 [[RS2:%.*]], i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    store i64 [[RS3:%.*]], i64* [[RS3_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i64, i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i64, i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP2:%.*]] = load i64, i64* [[RS3_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP3:%.*]] = call i64 @llvm.riscv.fsl.i64(i64 [[TMP0]], i64 [[TMP1]], i64 [[TMP2]])
// RV64ZBT-NEXT:    ret i64 [[TMP3]]
//
long fslw(long rs1, long rs2, long rs3) {
  return __builtin_riscv_fsl_64(rs1, rs2, rs3);
}

// RV64ZBT-LABEL: @fsrw(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    store i64 [[RS1:%.*]], i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    store i64 [[RS2:%.*]], i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    store i64 [[RS3:%.*]], i64* [[RS3_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i64, i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i64, i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP2:%.*]] = load i64, i64* [[RS3_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP3:%.*]] = call i64 @llvm.riscv.fsr.i64(i64 [[TMP0]], i64 [[TMP1]], i64 [[TMP2]])
// RV64ZBT-NEXT:    ret i64 [[TMP3]]
//
long fsrw(long rs1, long rs2, long rs3) {
  return __builtin_riscv_fsr_64(rs1, rs2, rs3);
}

// RV64ZBT-LABEL: @fsriw(
// RV64ZBT-NEXT:  entry:
// RV64ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i64, align 8
// RV64ZBT-NEXT:    store i64 [[RS1:%.*]], i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    store i64 [[RS2:%.*]], i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP0:%.*]] = load i64, i64* [[RS1_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP1:%.*]] = load i64, i64* [[RS2_ADDR]], align 8
// RV64ZBT-NEXT:    [[TMP2:%.*]] = call i64 @llvm.riscv.fsr.i64(i64 [[TMP0]], i64 [[TMP1]], i64 15)
// RV64ZBT-NEXT:    ret i64 [[TMP2]]
//
long fsriw(long rs1, long rs2) {
  return __builtin_riscv_fsr_64(rs1, rs2, 15);
}
