---
name: Bug report
about: Create a report to help us improve
title: ''
labels: 'priority: p2, type: bug'
assignees: ''

---

**Does this issue affect the google-cloud-cpp project?**
If the problem is with the Google Cloud service exposed by the `google-cloud-cpp` libraries instead of the client libraries themselves, you may consider opening a support request instead. The `google-cloud-cpp` developers cannot help you troubleshoot problems with the service itself.

**What component of `google-cloud-cpp` is this related to?**
For example, is this related to bigtable (i.e., something in `google/cloud/bigtable`), or GCS (i.e., something in `google/cloud/storage`)?

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior:
1. Call function '...'
2. Consume  '....'
3. ...
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Operating system:**
If you are using a Linux distribution please include the name and version of the distribution too.

**What compiler and version are you using?**
Please include the output of `g++ -v` or `clang++ -v` or the equivalent command-line flag.

**What version of `google-cloud-cpp` are you using?**
Please include the output from `git rev-parse HEAD` if you are compiling from source, or the version number from the applicable `google/cloud/*/version.h` file.

**Additional context**
Add any other context about the problem here.
