# -*- coding: utf-8 -*-

#
# Copyright (c) 2012 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

'''
A helper class to create an single instance of the redhat_support_lib
API object.
'''


from redhat_support_lib.api import API
import redhat_support_tool.helpers.confighelper as confighelper
from redhat_support_tool.helpers.confighelper import TOKEN_ENDPOINT_DICT
import redhat_support_tool.helpers.version as version
import logging

__author__ = 'Keith Robertson <kroberts@redhat.com>'
USER_AGENT = 'redhat-support-tool-%s' % (version.version)
_api = None
logger = logging.getLogger("redhat_support_tool.plugins.list_cases")


def str_to_bool(s):
    '''
    Converts a string representing a boolean to an actual boolean
    '''
    if isinstance(s, bool):
        return s
    if not isinstance(s, str):
        return None

    s = s.strip().lower()
    if s in ['false', 'f', 'no', 'n', '0']:
        return False
    if s in ['true', 't', 'yes', 'y', '1']:
        return True
    return None


def _make_api():
    cfg = confighelper.get_config_helper()

    logger.log(logging.DEBUG, 'user(%s)' % cfg.get(option='user'))
    logger.log(logging.DEBUG, 'proxy_url(%s)' % cfg.get(option='proxy_url'))
    logger.log(logging.DEBUG, 'proxy_user(%s)' % cfg.get(option='proxy_user'))
    '''
    logger.log(logging.DEBUG, 'password(%s)' % cfg.pw_decode(cfg.get(option='password'),
                                                             cfg.get(option='user')))
    logger.log(logging.DEBUG, 'proxy_password(%s)' % cfg.pw_decode(
                                                     cfg.get(option='proxy_password'),
                                                     cfg.get(option='proxy_user')))
    '''
    global _api
    if not _api:
        try:
            url = cfg.get(option='url')
            env = cfg.get_env(url)
            user = cfg.get(option='user')
            passwd = cfg.pw_decode(cfg.get(option='password'), cfg.get(option='user'))
            sftp_port = cfg.get(option='sftp_port') if cfg.get(option='sftp_port') is not None else 22
            sftp_timeout = cfg.get(option='sftp_timeout') if cfg.get(option='sftp_timeout') is not None else 2*60*60
            sftp_host = cfg.get(option='sftp_host') if cfg.get(option='sftp_host') is not None else cfg.get_sftp_host(url)
            use_basic_auth = str_to_bool(cfg.get(option='use_basic_auth')) \
                if cfg.get(option='use_basic_auth') is not None else False
            client_id = cfg.get(option='client_id')
            client_secret = cfg.pw_decode(cfg.get(option='client_secret'), cfg.get(option='client_id'))
            client_identifier_url = cfg.get(option='client_identifier_url')\
                if cfg.get(option='client_identifier_url') is not None else TOKEN_ENDPOINT_DICT[env]['client_identifier_url']
            token_endpoint = cfg.get(option='token_endpoint')\
                if cfg.get(option='token_endpoint') is not None else TOKEN_ENDPOINT_DICT[env]['token_endpoint']
            save_token = cfg.get(option='save_token')

            if use_basic_auth == None:
                use_basic_auth = False

            # ensure we have a userid
            if user == None or user == '':
                user = cfg.prompt_for_user()

            # ensure we have a password
            if use_basic_auth and (passwd == None or passwd == ''):
                passwd = cfg.prompt_for_password()

            if not use_basic_auth and client_id and (client_secret == None or client_secret == ''):
                client_secret = cfg.prompt_for_client_secret()

            if not use_basic_auth and not client_id and (str_to_bool(save_token) == None or save_token == ''):
                save_token = cfg.prompt_for_save_token()

            if str_to_bool(save_token):
                logger.log(logging.DEBUG, 'The save_token config is set to True. The token will be saved locally')

            if str_to_bool(cfg.get(option='no_verify_ssl')):
                no_verify_ssl = True
            else:
                no_verify_ssl = False

            ssl_ca = cfg.get(option='ssl_ca')

            use_threads = cfg.get(option='s3_use_threads')

            if use_threads is not None:
                use_threads = False if use_threads.lower() == 'false' else True

            aws_verify = cfg.get(option='s3_aws_verify')

            if aws_verify is not None:
                if aws_verify.strip().lower() == 'false':
                    aws_verify = False
                elif aws_verify.strip().lower() == 'true':
                    aws_verify = True
                else:
                    aws_verify = aws_verify


            s3_kwargs = {
                's3_aws_host': cfg.get(option='s3_aws_host'),
                's3_use_threads': use_threads,
                's3_max_workers': cfg.get(option='s3_max_workers'),
                's3_refresh_frequency': cfg.get(option='s3_refresh_frequency'),
                's3_multipart_threshold': cfg.get(option='s3_multipart_threshold'),
                's3_part_size': cfg.get(option='s3_part_size'),
                's3_endpoint_url': cfg.get(option='s3_endpoint_url'),
                's3_max_status_retries': cfg.get(option='s3_max_status_retries'),
                's3_failure_retries': cfg.get(option='s3_failure_retries'),
                's3_aws_verify': aws_verify
            }

            if url:
                _api = API(username=cfg.get(option='user'),
                               password=cfg.pw_decode(cfg.get(option='password'),
                                                      cfg.get(option='user')),
                               url=url,
                               proxy_url=cfg.get(option='proxy_url'),
                               proxy_user=cfg.get(option='proxy_user'),
                               proxy_pass=cfg.pw_decode(cfg.get(option='proxy_password'),
                                                        cfg.get(option='proxy_user')),
                               sftp_host=sftp_host,
                               userAgent=USER_AGENT,
                               no_verify_ssl=no_verify_ssl,
                               ssl_ca=ssl_ca,
                               sftp_port=sftp_port,
                               sftp_timeout=sftp_timeout,
                               client_id=cfg.get(option='client_id'),
                               client_secret=cfg.pw_decode(cfg.get(option='client_secret'),
                                                       cfg.get(option='client_id')),
                               token_endpoint=token_endpoint,
                               client_identifier_url=client_identifier_url,
                               use_basic_auth=use_basic_auth,
                               save_token=str_to_bool(save_token),
                               **s3_kwargs)
            else:
                _api = API(username=cfg.get(option='user'),
                               password=cfg.pw_decode(cfg.get(option='password'),
                                                      cfg.get(option='user')),
                               proxy_url=cfg.get(option='proxy_url'),
                               proxy_user=cfg.get(option='proxy_user'),
                               proxy_pass=cfg.pw_decode(cfg.get(option='proxy_password'),
                                                        cfg.get(option='proxy_user')),
                               userAgent=USER_AGENT,
                               no_verify_ssl=no_verify_ssl,
                               sftp_host=sftp_host,
                               ssl_ca=ssl_ca,
                               sftp_port=sftp_port,
                               sftp_timeout=sftp_timeout,
                               client_id=cfg.get(option='client_id'),
                               client_secret=cfg.pw_decode(cfg.get(option='client_secret'),
                                                       cfg.get(option='client_id')),
                               token_endpoint=token_endpoint,
                               client_identifier_url=client_identifier_url,
                               use_basic_auth=use_basic_auth,
                               save_token=str_to_bool(save_token),
                               **s3_kwargs)
        except:
            # Ideally we could just get rid of this try: except: block as it
            # does absolutely nothing!
            raise
    return _api


def get_api():
    '''
    A helper method to get the API object.
    '''
    # Tell python we want the *global* version and not a
    # function local version. Sheesh. :(
    global _api
    if not _api:
        _api = _make_api()
    return _api


def disconnect_api():
    '''
    Gracefully shutdown the API.
    '''
    global _api
    if _api:
        _api.disconnect()
        _api = None
