/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.cli;

import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemDBUpgradeCLI;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CADBUpgradeCLI
extends SubsystemDBUpgradeCLI {
    public static Logger logger = LoggerFactory.getLogger(CADBUpgradeCLI.class);

    public CADBUpgradeCLI(CLI parent) {
        super("upgrade", "Upgrade CA database", parent);
    }

    public void upgrade(LDAPConfig ldapConfig, LdapBoundConnection conn) throws Exception {
        logger.info("Searching certificates records with missing issuerName");
        String baseDN = ldapConfig.getBaseDN();
        String certRepoDN = "ou=certificateRepository,ou=ca," + baseDN;
        LDAPSearchResults results = conn.search(certRepoDN, 1, "(&(objectclass=certificateRecord)(|(!(issuerName=*))(issuerName=)))", null, false);
        while (results.hasMoreElements()) {
            LDAPEntry entry = results.next();
            logger.info("Updating certificate record " + entry.getDN());
            LDAPAttributeSet attrs = entry.getAttributeSet();
            LDAPAttribute userCertificate = attrs.getAttribute("userCertificate;binary");
            byte[] bytes = (byte[])userCertificate.getByteValues().nextElement();
            X509CertImpl cert = new X509CertImpl(bytes);
            String issuerDN = cert.getIssuerName().toString();
            logger.info("Setting issuerName to " + issuerDN);
            LDAPModification mods = new LDAPModification(0, new LDAPAttribute("issuerName", issuerDN));
            conn.modify(entry.getDN(), mods);
        }
    }
}

