/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjAltNameExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SubjAltNameExt.class);
    protected static final String PROP_AGENT_OVERR = "allowAgentOverride";
    protected static final String PROP_EE_OVERR = "AllowEEOverride";
    protected static final String PROP_ENABLE_MANUAL_VALUES = "enableManualValues";
    protected static final String PROP_CRITICAL = "critical";
    protected boolean mAllowAgentOverride = false;
    protected boolean mAllowEEOverride = false;
    protected boolean mEnableManualValues = false;
    protected boolean mCritical = false;

    public SubjAltNameExt() {
        this.NAME = "SubjAltNameExt";
        this.DESC = "Sets alternative subject names for certificates";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: If the certificate subject field contains an empty sequence, the subjectAltName extension MUST be marked critical.", "HELP_TOKEN;configuration-policyrules-subjaltname", "HELP_TEXT;This policy inserts the Subject Alternative Name Extension into the certificate. See RFC 2459 (4.2.1.7). * Note: you probably want to use this policy in conjunction with an authentication manager which sets the 'mail' or 'mailalternateaddress' values in the authToken. See the 'ldapStringAttrs' parameter in the Directory-based authentication plugin"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mAllowAgentOverride = config.getBoolean(PROP_AGENT_OVERR, false);
        this.mAllowEEOverride = config.getBoolean(PROP_EE_OVERR, false);
        this.mCritical = config.getBoolean(PROP_CRITICAL, false);
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return res;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        PolicyResult res = PolicyResult.ACCEPTED;
        try {
            Vector<String> emails;
            AuthToken tok;
            String certType;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions != null) {
                try {
                    extensions.delete("SubjectAlternativeName");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((certType = req.getExtDataInString("HTTP_PARAMS", "certType")) != null && certType.equals("client") && req.getExtDataInBoolean("SMIME", false) && (tok = this.findAuthToken(req, null)) != null && (emails = this.getEmailList(tok)) != null) {
                SubjectAlternativeNameExtension subjAltNameExt = this.mkExt(emails);
                if (extensions == null) {
                    extensions = this.createCertificateExtensions(certInfo);
                }
                extensions.set("SubjectAlternativeName", (Object)subjAltNameExt);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
        return res;
    }

    protected AuthToken findAuthToken(Request req, String authMgrName) {
        return req.getExtDataInAuthToken("AUTH_TOKEN");
    }

    protected Vector<String> getEmailList(AuthToken tok) throws IOException {
        Vector<String> v = new Vector<String>();
        this.addValues(tok, "mail", v);
        this.addValues(tok, "mailalternateaddress", v);
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    protected void addValues(AuthToken tok, String attrName, Vector<String> v) throws IOException {
        String[] attr = tok.getInStringArray(attrName);
        if (attr == null) {
            return;
        }
        for (int i = 0; i < attr.length; ++i) {
            v.addElement(attr[i]);
        }
    }

    protected SubjectAlternativeNameExtension mkExt(Vector<String> emails) throws IOException {
        GeneralNames gns = new GeneralNames();
        for (int i = 0; i < emails.size(); ++i) {
            String email = emails.elementAt(i);
            gns.addElement((Object)new RFC822Name(email));
        }
        SubjectAlternativeNameExtension sa = new SubjectAlternativeNameExtension(gns);
        return sa;
    }

    protected CertificateExtensions createCertificateExtensions(X509CertInfo certInfo) throws IOException, CertificateException {
        certInfo.set("version", (Object)new CertificateVersion(2));
        CertificateExtensions extensions = new CertificateExtensions();
        certInfo.set("extensions", (Object)extensions);
        return extensions;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        return defParams;
    }
}

