/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.PolicyConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyConstraintsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(PolicyConstraintsExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_REQ_EXPLICIT_POLICY = "reqExplicitPolicy";
    protected static final String PROP_INHIBIT_POLICY_MAPPING = "inhibitPolicyMapping";
    protected static final boolean DEF_CRITICAL = false;
    protected static final int DEF_REQ_EXPLICIT_POLICY = -1;
    protected static final int DEF_INHIBIT_POLICY_MAPPING = -1;
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = false;
    protected int mReqExplicitPolicy = -1;
    protected int mInhibitPolicyMapping = -1;
    protected PolicyConstraintsExtension mPolicyConstraintsExtension = null;
    protected Vector<String> mInstanceParams = new Vector();
    protected static Vector<String> mDefaultParams = new Vector();

    public PolicyConstraintsExt() {
        this.NAME = "PolicyConstriantsExt";
        this.DESC = "Sets Policy Constraints Extension on subordinate CA certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mReqExplicitPolicy = this.mConfig.getInteger(PROP_REQ_EXPLICIT_POLICY, -1);
        this.mInhibitPolicyMapping = this.mConfig.getInteger(PROP_INHIBIT_POLICY_MAPPING, -1);
        if (this.mReqExplicitPolicy < -1) {
            this.mReqExplicitPolicy = -1;
        }
        if (this.mInhibitPolicyMapping < -1) {
            this.mInhibitPolicyMapping = -1;
        }
        try {
            this.mPolicyConstraintsExtension = new PolicyConstraintsExtension(this.mCritical, this.mReqExplicitPolicy, this.mInhibitPolicyMapping);
            logger.debug("PolicyConstraintsExt: Created Policy Constraints Extension: " + this.mPolicyConstraintsExtension);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_CANT_INIT_POLICY_CONST_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Could not init Policy Constraints Extension. Error: " + e}), (Throwable)e);
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("reqExplicitPolicy=" + this.mReqExplicitPolicy);
        this.mInstanceParams.addElement("inhibitPolicyMapping=" + this.mInhibitPolicyMapping);
    }

    public PolicyResult apply(Request req) {
        if (this.mPolicyConstraintsExtension == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            PolicyConstraintsExtension policyConstraintsExt = null;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            try {
                if (extensions != null) {
                    policyConstraintsExt = (PolicyConstraintsExtension)extensions.get("PolicyConstraints");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (policyConstraintsExt != null) {
                if (this.agentApproved(req)) {
                    return PolicyResult.ACCEPTED;
                }
                extensions.delete("PolicyConstraints");
            }
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            extensions.set("PolicyConstriantsExt", (Object)this.mPolicyConstraintsExtension);
            logger.debug("PolicyConstraintsExt: added our policy constraints extension");
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_CANT_PROCESS_POLICY_CONST_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefaultParams;
    }

    public String[] getExtendedPluginInfo() {
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("reqExplicitPolicy=" + this.mReqExplicitPolicy);
        this.mInstanceParams.addElement("inhibitPolicyMapping=" + this.mInhibitPolicyMapping);
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: may be critical or non-critical.", "reqExplicitPolicy;integer;Number of addional certificates that may appear in the path before an explicit policy is required. If less than 0 this field is unset in the extension.", "inhibitPolicyMapping;integer;Number of addional certificates that may appear in the path before policy mapping is no longer permitted. If less than 0 this field is unset in the extension.", "HELP_TOKEN;configuration-policyrules-policyconstraints"};
        return params;
    }

    static {
        mDefaultParams.addElement("critical=false");
        mDefaultParams.addElement("reqExplicitPolicy=-1");
        mDefaultParams.addElement("inhibitPolicyMapping=-1");
    }
}

