/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class ValidityConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    protected long mMinValidity;
    protected long mMaxValidity;
    protected long mLeadTime;
    protected long mLagTime;
    protected long mNotBeforeSkew;
    private static final String PROP_MIN_VALIDITY = "minValidity";
    private static final String PROP_MAX_VALIDITY = "maxValidity";
    private static final String PROP_LEAD_TIME = "leadTime";
    private static final String PROP_LAG_TIME = "lagTime";
    private static final String PROP_NOT_BEFORE_SKEW = "notBeforeSkew";
    public static final int DEF_MIN_VALIDITY = 180;
    public static final int DEF_MAX_VALIDITY = 730;
    public static final int DEF_LEAD_TIME = 10;
    public static final int DEF_LAG_TIME = 10;
    public static final int DEF_NOT_BEFORE_SKEW = 5;
    public static final long DAYS_TO_MS_FACTOR = 86400000L;
    public static final long MINS_TO_MS_FACTOR = 60000L;
    private static final Vector<String> defConfParams = new Vector();

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"minValidity;number;Minimum Validity time, in days", "maxValidity;number;Maximum Validity time, in days", "leadTime;number;Number of minutes in the future a request's notBefore can be", "lagTime;number;NOT CURRENTLY IN USE", "notBeforeSkew;number;Number of minutes a cert's notBefore should be in the past", "HELP_TOKEN;configuration-policyrules-validityconstraints", "HELP_TEXT;Ensures that the user's requested validity period is acceptable. If not specified, as is usually the case, this policy will set the validity. See RFC 2459."};
        return params;
    }

    public ValidityConstraints() {
        this.NAME = "ValidityConstraints";
        this.DESC = "Enforces minimum and maximum validity constraints.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        try {
            String val = config.getString(PROP_MIN_VALIDITY, null);
            this.mMinValidity = val == null ? 15552000000L : Long.parseLong(val) * 86400000L;
            val = config.getString(PROP_MAX_VALIDITY, null);
            this.mMaxValidity = val == null ? 63072000000L : Long.parseLong(val) * 86400000L;
            val = config.getString(PROP_LEAD_TIME, null);
            this.mLeadTime = val != null ? Long.parseLong(val) * 60000L : 600000L;
            val = config.getString(PROP_LAG_TIME, null);
            this.mLagTime = val != null ? Long.parseLong(val) * 60000L : 600000L;
            val = config.getString(PROP_NOT_BEFORE_SKEW, null);
            this.mNotBeforeSkew = val != null ? Long.parseLong(val) * 60000L : 300000L;
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])params));
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfo == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfo.length; ++i) {
                String[] params;
                CertificateValidity validity = (CertificateValidity)certInfo[i].get("validity");
                Date notBefore = null;
                Date notAfter = null;
                if (validity != null) {
                    notBefore = (Date)validity.get("notBefore");
                    notAfter = (Date)validity.get("notAfter");
                }
                if (validity == null || notBefore.getTime() == 0L && notAfter.getTime() == 0L) {
                    certInfo[i].set("validity", (Object)this.makeDefaultValidity(req));
                    continue;
                }
                Date now = new Date();
                if (notBefore.getTime() > now.getTime() + this.mLeadTime) {
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_INVALID_BEGIN_TIME", (String[])new String[]{this.getInstanceName()}), "");
                    result = PolicyResult.REJECTED;
                }
                if (notAfter.getTime() - notBefore.getTime() > this.mMaxValidity) {
                    params = new String[]{this.getInstanceName(), String.valueOf((notAfter.getTime() - notBefore.getTime()) / 86400000L), String.valueOf(this.mMaxValidity / 86400000L)};
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_MORE_THAN_MAX_VALIDITY", (String[])params), "");
                    result = PolicyResult.REJECTED;
                }
                if (notAfter.getTime() - notBefore.getTime() >= this.mMinValidity) continue;
                params = new String[]{this.getInstanceName(), String.valueOf((notAfter.getTime() - notBefore.getTime()) / 86400000L), String.valueOf(this.mMinValidity / 86400000L)};
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_LESS_THAN_MIN_VALIDITY", (String[])params), "");
                result = PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("minValidity=" + this.mMinValidity / 86400000L);
        confParams.addElement("maxValidity=" + this.mMaxValidity / 86400000L);
        confParams.addElement("leadTime=" + this.mLeadTime / 60000L);
        confParams.addElement("lagTime=" + this.mLagTime / 60000L);
        confParams.addElement("notBeforeSkew=" + this.mNotBeforeSkew / 60000L);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    protected CertificateValidity makeDefaultValidity(Request req) {
        long now = this.roundTimeToSecond(new Date().getTime());
        long notBeforeTime = now - this.mNotBeforeSkew;
        Date notBefore = new Date(notBeforeTime);
        Date notAfter = new Date(notBeforeTime + this.mMaxValidity);
        return new CertificateValidity(notBefore, notAfter);
    }

    protected long roundTimeToSecond(long input) {
        return input / 1000L * 1000L;
    }

    static {
        defConfParams.addElement("minValidity=180");
        defConfParams.addElement("maxValidity=730");
        defConfParams.addElement("leadTime=10");
        defConfParams.addElement("lagTime=10");
        defConfParams.addElement("notBeforeSkew=5");
    }
}

