/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningAlgorithmConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SigningAlgorithmConstraints.class);
    private String[] mAllowedAlgs = null;
    static String[] mDefaultAllowedAlgs = null;
    private String[] mConfigAlgs = null;
    private boolean winnowedByKey = false;
    IAuthority mAuthority = null;
    private static final String PROP_ALGORITHMS = "algorithms";
    private static final Vector<String> defConfParams = new Vector();

    public SigningAlgorithmConstraints() {
        this.NAME = "SigningAlgorithmConstraints";
        this.DESC = "Enforces Signing Algorithm Constraints.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mAuthority = owner.getAuthority();
        if (config != null) {
            String algNames = null;
            try {
                algNames = config.getString(PROP_ALGORITHMS, null);
            }
            catch (Exception e) {
                String[] params = new String[]{this.getInstanceName(), e.toString(), PROP_ALGORITHMS};
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_PARAM_CONFIG_ERROR", (String[])params));
            }
            if (algNames != null) {
                StringTokenizer tok = new StringTokenizer(algNames, ",");
                Vector<String> algs = new Vector<String>();
                while (tok.hasMoreTokens()) {
                    algs.addElement(tok.nextToken().trim());
                }
                int itemCount = algs.size();
                this.mAllowedAlgs = new String[itemCount];
                for (int i = 0; i < itemCount; ++i) {
                    this.mAllowedAlgs[i] = (String)algs.elementAt(i);
                }
            }
        }
        this.mConfigAlgs = this.mAllowedAlgs;
        if (this.mConfigAlgs == null) {
            this.mConfigAlgs = new String[0];
        }
        if (this.mAllowedAlgs != null) {
            this.winnowAlgs(AlgorithmId.ALL_SIGNING_ALGORITHMS, "CMS_POLICY_UNKNOWN_SIGNING_ALG", true);
        } else {
            this.mAllowedAlgs = AlgorithmId.ALL_SIGNING_ALGORITHMS;
        }
        this.winnowByKey();
        if (this.mAllowedAlgs.length == 0) {
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_SIGNALG_NOT_MATCH_CAKEY", (String[])new String[]{this.NAME}));
        }
    }

    private synchronized void winnowByKey() throws EBaseException {
        if (this.winnowedByKey) {
            return;
        }
        if (!(this.mAuthority instanceof CertificateAuthority)) {
            this.winnowedByKey = true;
            return;
        }
        String[] allowedByKey = ((CertificateAuthority)this.mAuthority).getCASigningAlgorithms();
        if (allowedByKey != null) {
            mDefaultAllowedAlgs = new String[allowedByKey.length];
            for (int i = 0; i < allowedByKey.length; ++i) {
                SigningAlgorithmConstraints.mDefaultAllowedAlgs[i] = allowedByKey[i];
            }
            this.winnowAlgs(allowedByKey, "CMS_POLICY_SIGNALG_NOT_MATCH_CAKEY_1", false);
            this.winnowedByKey = true;
        }
    }

    private void winnowAlgs(String[] allowed, String reason, boolean isError) throws EBaseException {
        int i;
        Vector<String> goodAlgs = new Vector<String>();
        for (i = 0; i < this.mAllowedAlgs.length; ++i) {
            int j;
            for (j = 0; j < allowed.length; ++j) {
                if (!this.mAllowedAlgs[i].equals(allowed[j])) continue;
                goodAlgs.addElement(this.mAllowedAlgs[i]);
                break;
            }
            if (j != allowed.length) continue;
            EPolicyException e = new EPolicyException(CMS.getUserMessage((String)reason, (String[])new String[]{this.NAME, this.mAllowedAlgs[i]}));
            if (isError) {
                logger.error("SigningAlgorithmConstraints: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            logger.warn("SigningAlgorithmConstraints: " + e.getMessage(), (Throwable)e);
        }
        int goodSize = goodAlgs.size();
        if (this.mAllowedAlgs.length != goodSize) {
            this.mAllowedAlgs = new String[goodSize];
            for (i = 0; i < goodSize; ++i) {
                this.mAllowedAlgs[i] = (String)goodAlgs.elementAt(i);
            }
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfo == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfo.length; ++i) {
                int j;
                if (!this.winnowedByKey) {
                    this.winnowByKey();
                }
                CertificateAlgorithmId certAlgId = (CertificateAlgorithmId)certInfo[i].get("algorithmID");
                AlgorithmId algId = (AlgorithmId)certAlgId.get("algorithm");
                String alg = algId.getName();
                for (j = 0; j < this.mAllowedAlgs.length && !this.mAllowedAlgs[j].equals(alg); ++j) {
                }
                if (j != this.mAllowedAlgs.length) continue;
                if (this.mAllowedAlgs[0].equals("SHA1withDSA") || alg.equals("SHA1withDSA")) {
                    certInfo[i].set("algorithmID", (Object)new CertificateAlgorithmId(AlgorithmId.get((String)this.mAllowedAlgs[0])));
                    return PolicyResult.ACCEPTED;
                }
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_SIGNING_ALG_VIOLATION", (String[])new String[]{this.getInstanceName(), alg}), "");
                result = PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mConfigAlgs.length; ++i) {
            sb.append(this.mConfigAlgs[i]);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        confParams.addElement("algorithms=" + sb.toString());
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        StringBuffer sb = new StringBuffer();
        sb.append(PROP_ALGORITHMS);
        sb.append("=");
        boolean first = true;
        defConfParams.removeAllElements();
        for (int i = 0; i < mDefaultAllowedAlgs.length; ++i) {
            if (first) {
                sb.append(mDefaultAllowedAlgs[i]);
                first = false;
                continue;
            }
            sb.append(",");
            sb.append(mDefaultAllowedAlgs[i]);
        }
        defConfParams.addElement(sb.toString());
        return defConfParams;
    }

    public String[] getExtendedPluginInfo() {
        if (!this.winnowedByKey) {
            try {
                this.winnowByKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] params = null;
        String[] params_BOTH = new String[]{"algorithms;choice(MD2withRSA\\,MD5withRSA\\,SHA1withRSA\\,SHA256withRSA\\,SHA512withRSA\\,SHA1withDSA,MD2withRSA\\,MD5withRSA\\,SHA1withRSA\\,SHA1withDSA,MD2withRSA\\,MD5withRSA\\,SHA1withRSA,MD2withRSA\\,SHA1withRSA\\,SHA1withDSA,MD5withRSA\\,SHA1withRSA\\,SHA1withDSA,MD2withRSA\\,MD5withRSA\\,SHA1withDSA,MD2withRSA\\,MD5withRSA,MD2withRSA\\,SHA1withRSA,MD2withRSA\\,SHA1withDSA,MD5withRSA\\,SHA1withRSA,MD5withRSA\\,SHA1withDSA,SHA1withRSA\\,SHA1withDSA,MD2withRSA,MD5withRSA,SHA1withRSA,SHA1withDSA);List of algorithms to restrict the requested signing algorithm to be one of the algorithms supported by Certificate System", "HELP_TOKEN;configuration-policyrules-signingalgconstraints", "HELP_TEXT;Restricts the requested signing algorithm to be one of the algorithms supported by Certificate System"};
        String[] params_RSA = new String[]{"algorithms;choice(MD2withRSA\\,MD5withRSA\\,SHA1withRSA,MD2withRSA\\,MD5withRSA,MD2withRSA\\,SHA1withRSA,MD5withRSA\\,SHA1withRSA,MD2withRSA,MD5withRSA,SHA1withRSA);Restrict the requested signing algorithm to be one of the algorithms supported by Certificate System", "HELP_TOKEN;configuration-policyrules-signingalgconstraints", "HELP_TEXT;Restricts the requested signing algorithm to be one of the algorithms supported by Certificate System"};
        String[] params_DSA = new String[]{"algorithms;choice(SHA1withDSA);Restrict the requested signing algorithm to be one of the algorithms supported by Certificate System", "HELP_TOKEN;configuration-policyrules-signingalgconstraints", "HELP_TEXT;Restricts the requested signing algorithm to be one of the algorithms supported by Certificate System"};
        switch (mDefaultAllowedAlgs.length) {
            case 1: {
                params = params_DSA;
                break;
            }
            case 3: {
                params = params_RSA;
                break;
            }
            default: {
                params = params_BOTH;
            }
        }
        return params;
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append(PROP_ALGORITHMS);
        sb.append("=");
        int i = 0;
        boolean first = true;
        mDefaultAllowedAlgs = new String[AlgorithmId.ALL_SIGNING_ALGORITHMS.length];
        for (i = 0; i < AlgorithmId.ALL_SIGNING_ALGORITHMS.length; ++i) {
            SigningAlgorithmConstraints.mDefaultAllowedAlgs[i] = AlgorithmId.ALL_SIGNING_ALGORITHMS[i];
            if (first) {
                sb.append(AlgorithmId.ALL_SIGNING_ALGORITHMS[i]);
                first = false;
                continue;
            }
            sb.append(",");
            sb.append(AlgorithmId.ALL_SIGNING_ALGORITHMS[i]);
        }
        defConfParams.addElement(sb.toString());
    }
}

