/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IRenewalPolicy;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewalConstraints
extends APolicyRule
implements IRenewalPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(RenewalConstraints.class);
    private static final String PROP_ALLOW_EXPIRED_CERTS = "allowExpiredCerts";
    private static final String PROP_RENEWAL_NOT_AFTER = "renewalNotAfter";
    private boolean mAllowExpiredCerts = true;
    private long mRenewalNotAfter = 0L;
    public static final int DEF_RENEWAL_NOT_AFTER = 30;
    public static final long DAYS_TO_MS_FACTOR = 86400000L;
    private static final Vector<String> defConfParams = new Vector();

    public RenewalConstraints() {
        this.NAME = "RenewalConstraints";
        this.DESC = "Whether to allow renewal of expired certs.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"allowExpiredCerts;boolean;Allow a user to renew an already-expired certificate", "renewalNotAfter;number;Number of days since certificate expiry after which renewal request would be rejected", "HELP_TOKEN;configuration-policyrules-renewalconstraints", "HELP_TEXT;Permit administrator to decide policy on whether to permit renewals for already-expired certificates"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        try {
            this.mAllowExpiredCerts = config.getBoolean(PROP_ALLOW_EXPIRED_CERTS, true);
            String val = config.getString(PROP_RENEWAL_NOT_AFTER, null);
            this.mRenewalNotAfter = val == null ? 2592000000L : Long.parseLong(val) * 86400000L;
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        logger.debug("RenewalConstraints: allow expired certs " + this.mAllowExpiredCerts);
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertImpl[] oldCerts = req.getExtDataInCertArray("OLD_CERTS");
            if (oldCerts == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_OLD_CERT", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            if (this.mAllowExpiredCerts) {
                logger.debug("checking validity of each cert");
                for (int i = 0; i < oldCerts.length; ++i) {
                    X509CertInfo oldCertInfo = (X509CertInfo)oldCerts[i].get("x509.info");
                    CertificateValidity oldValidity = (CertificateValidity)oldCertInfo.get("validity");
                    Date notAfter = (Date)oldValidity.get("notAfter");
                    Date now = new Date();
                    Date renewedNotAfter = new Date(notAfter.getTime() + this.mRenewalNotAfter);
                    logger.debug("RenewalConstraints: cert " + i + " renewedNotAfter " + renewedNotAfter + " now=" + now);
                    if (!renewedNotAfter.before(now)) continue;
                    logger.debug("One or more certificates is expired for more than " + this.mRenewalNotAfter / 86400000L + " days");
                    String[] params = new String[]{this.getInstanceName(), Long.toString(this.mRenewalNotAfter / 86400000L)};
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CANNOT_RENEW_EXPIRED_CERTS_AFTER_ALLOWED_PERIOD", (String[])params), "");
                    return PolicyResult.REJECTED;
                }
                return PolicyResult.ACCEPTED;
            }
            logger.debug("RenewalConstraints: checking validity of each cert");
            for (int i = 0; i < oldCerts.length; ++i) {
                X509CertInfo oldCertInfo = (X509CertInfo)oldCerts[i].get("x509.info");
                CertificateValidity oldValidity = (CertificateValidity)oldCertInfo.get("validity");
                Date notAfter = (Date)oldValidity.get("notAfter");
                Date now = new Date();
                logger.debug("RenewalConstraints: cert " + i + " notAfter " + notAfter + " now=" + now);
                if (!notAfter.before(now)) continue;
                logger.debug("RenewalConstraints: One or more certificates is expired.");
                String[] params = new String[]{this.getInstanceName()};
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CANNOT_RENEW_EXPIRED_CERTS", (String[])params), "");
                result = PolicyResult.REJECTED;
                break;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("allowExpiredCerts=" + this.mAllowExpiredCerts);
        confParams.addElement("renewalNotAfter=" + this.mRenewalNotAfter / 86400000L);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    static {
        defConfParams.addElement("allowExpiredCerts=true");
        defConfParams.addElement("renewalNotAfter=30");
    }
}

