/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.notification;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.notification.EmailResolver;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.notification.EmailResolverKeys;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqCertEmailResolver
extends EmailResolver {
    public static Logger logger = LoggerFactory.getLogger(ReqCertEmailResolver.class);

    @Override
    public String getEmail(EmailResolverKeys keys) throws EBaseException, ENotificationException {
        Request req = (Request)keys.get("request");
        String mEmail = null;
        if (req != null) {
            mEmail = req.getExtDataInString("HTTP_PARAMS", "csrRequestorEmail");
            if (mEmail == null) {
                String mail = req.getExtDataInString("requestor_email");
                logger.info("ReqCertEmailResolver: REQUESTOR_EMAIL = " + mail);
                if (mail != null && !mail.equals("")) {
                    return mail;
                }
            } else if (!mEmail.equals("")) {
                return mEmail;
            }
        } else {
            logger.warn("ReqCertEmailResolver: request null in keys");
        }
        X509Certificate cert = (X509Certificate)keys.get("cert");
        X500Name subjectDN = null;
        if (cert != null) {
            subjectDN = (X500Name)cert.getSubjectDN();
            try {
                mEmail = subjectDN.getEmail();
            }
            catch (IOException e) {
                System.out.println("X500Name getEmail failed");
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{subjectDN.toString()}));
            }
        } else {
            logger.warn("ReqCertEmailResolver: cert null in keys");
        }
        if (mEmail == null) {
            if (cert != null) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_EMAIL", (Object[])new Object[]{subjectDN.toString()}));
                logger.error("ReqCertEmailResolver: no email resolved, throwing NotificationResources.EMAIL_RESOLVE_FAILED_1 for " + subjectDN);
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN}));
            }
            if (req != null) {
                logger.error("ReqCertEmailResolver: no email resolved for request id =" + req.getRequestId());
                logger.error("ReqCertEmailResolver: throwing NotificationResources.EMAIL_RESOLVE_FAILED_1");
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"requestId= " + req.getRequestId()}));
            }
            logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_EMAIL_REQUEST", (Object[])new Object[0]));
            logger.error("ReqCertEmailResolver: no email resolved, throwing NotificationResources.EMAIL_RESOLVE_FAILED_1.  No request id or cert info found");
            throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{": No request id or cert info found"}));
        }
        logger.info("ReqCertEmailResolver: email resolved: " + mEmail);
        return mEmail;
    }
}

