/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.ldap.ExpressionComps;
import com.netscape.cmscore.ldap.LdapExpression;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.util.AssertionException;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSimpleExpression
extends LdapExpression {
    public static Logger logger = LoggerFactory.getLogger(LdapSimpleExpression.class);
    private String mPfx;
    private String mVar;
    private String mVal;
    private String mPartialMatch;
    private int mOp;
    private boolean hasWildCard;
    public static final char WILDCARD_CHAR = '*';
    public static LdapSimpleExpression NULL_EXPRESSION = new LdapSimpleExpression("null", 1, "null");

    public static LdapExpression parse(String input) throws ELdapException {
        String var = null;
        int op = -1;
        String val = null;
        ExpressionComps comps = LdapSimpleExpression.parseForEquality(input);
        if (comps == null) {
            comps = LdapSimpleExpression.parseForInEquality(input);
        }
        if (comps == null) {
            comps = LdapSimpleExpression.parseForGE(input);
        }
        if (comps == null) {
            comps = LdapSimpleExpression.parseForLE(input);
        }
        if (comps == null) {
            comps = LdapSimpleExpression.parseForGT(input);
        }
        if (comps == null) {
            comps = LdapSimpleExpression.parseForLT(input);
        }
        if (comps == null) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_BAD_LDAP_EXPRESSION", (String[])new String[]{input}));
        }
        String pfx = null;
        String rawVar = comps.getAttr();
        int dotIdx = rawVar.indexOf(46);
        if (dotIdx != -1) {
            pfx = rawVar.substring(0, dotIdx).trim();
            var = rawVar.substring(dotIdx + 1).trim();
        } else {
            var = rawVar;
        }
        op = comps.getOp();
        val = comps.getVal();
        return new LdapSimpleExpression(pfx, var, op, val);
    }

    public LdapSimpleExpression(String var, int op, String val) {
        this(null, var, op, val);
    }

    public LdapSimpleExpression(String prefix, String var, int op, String val) {
        this.mPfx = prefix;
        this.mVar = var;
        this.mOp = op;
        this.mVal = val;
        int firstIndex = this.mVal.indexOf(42);
        if (firstIndex >= 0) {
            this.hasWildCard = true;
            int nextIndex = this.mVal.indexOf(42, firstIndex + 1);
            this.mPartialMatch = nextIndex == -1 ? (firstIndex == 0 ? this.mVal.substring(1) : this.mVal.substring(0, firstIndex)) : this.mVal.substring(firstIndex + 1, nextIndex);
        } else {
            this.hasWildCard = false;
        }
    }

    @Override
    public boolean evaluate(SessionContext sc) throws ELdapException {
        Object givenVal;
        try {
            givenVal = sc.get((Object)this.mVar);
        }
        catch (Exception e) {
            givenVal = null;
        }
        if (givenVal == null) {
            try {
                givenVal = sc.get((Object)this.mVar.toLowerCase());
            }
            catch (Exception e) {
                givenVal = null;
            }
        }
        if (givenVal == null) {
            try {
                givenVal = sc.get((Object)this.mVar.toUpperCase());
            }
            catch (Exception e) {
                givenVal = null;
            }
        }
        logger.debug("LdapSimpleExpression: " + this.mVar + ": " + givenVal);
        boolean result = false;
        result = this.matchValue(givenVal);
        return result;
    }

    @Override
    public boolean evaluate(Request req) throws ELdapException {
        boolean result = false;
        result = this.mPfx != null ? this.matchValue(req.getExtDataInString(this.mPfx, this.mVar)) : this.matchValue(req.getExtDataInString(this.mVar));
        return result;
    }

    private boolean matchVector(Vector<Object> value) throws ELdapException {
        boolean result = false;
        Enumeration<Object> e = value.elements();
        while (e.hasMoreElements() && !(result = this.matchValue(e.nextElement()))) {
        }
        return result;
    }

    private boolean matchStringArray(String[] value) throws ELdapException {
        boolean result = false;
        for (int i = 0; i < value.length && !(result = this.matchValue(value[i])); ++i) {
        }
        return result;
    }

    private boolean matchValue(Object value) throws ELdapException {
        boolean result;
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            result = this.matchStringValue((String)value);
        } else if (value instanceof Integer) {
            result = this.matchIntegerValue((Integer)value);
        } else if (value instanceof Boolean) {
            result = this.matchBooleanValue((Boolean)value);
        } else if (value instanceof Vector) {
            result = this.matchVector((Vector)value);
        } else if (value instanceof String[]) {
            result = this.matchStringArray((String[])value);
        } else {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INVALID_ATTR_VALUE", (String[])new String[]{value.getClass().getName()}));
        }
        return result;
    }

    private boolean matchStringValue(String givenVal) throws ELdapException {
        return switch (this.mOp) {
            case 1 -> {
                if (this.hasWildCard) {
                    yield givenVal.indexOf(this.mPartialMatch) >= 0;
                }
                logger.debug("LdapSimpleExpression: Comparing string " + givenVal + " against " + this.mVal);
                yield givenVal.equalsIgnoreCase(this.mVal);
            }
            case 2 -> {
                if (this.hasWildCard) {
                    yield givenVal.indexOf(this.mPartialMatch) < 0;
                }
                yield !givenVal.equalsIgnoreCase(this.mVal);
            }
            case 4 -> givenVal.compareTo(this.mVal) < 0;
            case 3 -> givenVal.compareTo(this.mVal) > 0;
            case 5 -> givenVal.compareTo(this.mVal) >= 0;
            case 6 -> givenVal.compareTo(this.mVal) >= 0;
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    private boolean matchIntegerValue(Integer intVal) throws ELdapException {
        int storedVal;
        int givenVal = intVal;
        try {
            storedVal = Integer.valueOf(this.mVal);
        }
        catch (Exception e) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INVALID_ATTR_VALUE", (String[])new String[]{this.mVal}));
        }
        return switch (this.mOp) {
            case 1 -> givenVal == storedVal;
            case 2 -> givenVal != storedVal;
            case 4 -> givenVal < storedVal;
            case 3 -> givenVal > storedVal;
            case 5 -> givenVal >= storedVal;
            case 6 -> givenVal >= storedVal;
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    private boolean matchBooleanValue(Boolean givenVal) throws ELdapException {
        if (!this.mVal.equalsIgnoreCase("true") && !this.mVal.equalsIgnoreCase("false")) {
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INVALID_ATTR_VALUE", (String[])new String[]{this.mVal}));
        }
        Boolean storedVal = Boolean.valueOf(this.mVal);
        return switch (this.mOp) {
            case 1 -> givenVal.equals(storedVal);
            case 2, 3, 4, 5, 6 -> !givenVal.equals(storedVal);
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    @Override
    public String toString() {
        String op = null;
        switch (this.mOp) {
            case 1: {
                op = "==";
                break;
            }
            case 2: {
                op = "!=";
                break;
            }
            case 3: {
                op = ">";
                break;
            }
            case 4: {
                op = "<";
                break;
            }
            case 5: {
                op = ">=";
                break;
            }
            case 6: {
                op = "<=";
            }
        }
        if (this.mPfx == null || this.mPfx.length() <= 0) {
            return this.mVar + " " + op + " " + this.mVal;
        }
        return this.mPfx + "." + this.mVar + " " + op + " " + this.mVal;
    }

    private static ExpressionComps parseForEquality(String expression) {
        int index = expression.indexOf("==");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 1;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForInEquality(String expression) {
        int index = expression.indexOf("!=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 2;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForGT(String expression) {
        int index = expression.indexOf(">");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 3;
        String val = expression.substring(index + 1).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForLT(String expression) {
        int index = expression.indexOf("<");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 4;
        String val = expression.substring(index + 1).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForGE(String expression) {
        int index = expression.indexOf(">=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 5;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForLE(String expression) {
        int index = expression.indexOf("<=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 6;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }
}

