/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.LdapMappers;
import com.netscape.cmscore.ldap.LdapPublishModule;
import com.netscape.cmscore.request.Request;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandleRenewal
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(HandleRenewal.class);
    private LdapPublishModule mModule = null;

    public HandleRenewal(LdapPublishModule module) {
        this.mModule = module;
    }

    public void init(Subsystem sub, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
        if (certs == null || certs.length == 0) {
            logger.debug("no certs to publish for renewal request " + r.getRequestId());
            return;
        }
        Integer[] results = new Integer[certs.length];
        X509CertImpl cert = null;
        LdapMappers mappers = this.mModule.getMappers("client");
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for client is null");
            return;
        }
        boolean error = false;
        for (int i = 0; i < certs.length; ++i) {
            cert = certs[i];
            if (cert == null) continue;
            try {
                this.mModule.publish(mappers.mapper, mappers.publisher, (X509Certificate)cert);
                results[i] = Request.RES_SUCCESS;
                logger.info("Published cert serial no 0x" + cert.getSerialNumber().toString(16));
                continue;
            }
            catch (ELdapException e) {
                error = true;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_PUBLISH", (Object[])new Object[]{cert.getSerialNumber().toString(16), e.getMessage()}), (Throwable)e);
                results[i] = Request.RES_ERROR;
            }
        }
        r.setExtData("ldapPublishStatus", results);
        r.setExtData("ldapPublishOverAllStatus", error ? Request.RES_ERROR : Request.RES_SUCCESS);
    }
}

