/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileOutput;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.certsrv.template.ArgString;
import com.netscape.cms.servlet.cert.RequestProcessor;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProfileProcess", urlPatterns={"/agent/ca/profileProcess"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caProfileProcess"), @WebInitParam(name="unauthorizedTemplate", value="/GenUnauthorized.template"), @WebInitParam(name="templatePath", value="/agent/ca/ProfileProcess.template"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.request.profile")})
public class ProfileProcessServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileProcessServlet.class);
    private static final long serialVersionUID = 5244627530516577838L;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        Locale locale = this.getLocale(request);
        ArgSet args = new ArgSet();
        args.set("errorCode", "0");
        args.set("errorReason", "");
        CAEngine engine = (CAEngine)this.getCMSEngine();
        RequestProcessor processor = new RequestProcessor("caProfileProcess", locale);
        processor.setCMSEngine(engine);
        processor.init();
        String op = request.getParameter("op");
        logger.debug("ProfileProcessServlet: request operation: " + op);
        if (op == null) {
            logger.error("ProfileProcessServlet: Missing request operation");
            this.setError(args, CMS.getUserMessage((Locale)locale, (String)"CMS_OP_NOT_FOUND", (String[])new String[0]), request, response);
            return;
        }
        String requestId = request.getParameter("requestId");
        logger.debug("ProfileProcessServlet: request ID: " + requestId);
        if (requestId == null || requestId.equals("")) {
            logger.error("ProfileProcessServlet: Missing request ID");
            this.setError(args, CMS.getUserMessage((Locale)locale, (String)"CMS_REQUEST_ID_NOT_FOUND", (String[])new String[0]), request, response);
            return;
        }
        Request req = processor.getRequest(requestId);
        if (req == null) {
            logger.error("ProfileProcessServlet: Request not found: " + requestId);
            this.setError(args, CMS.getUserMessage((Locale)locale, (String)"CMS_REQUEST_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)requestId)}), request, response);
            return;
        }
        String profileId = req.getExtDataInString("profileId");
        logger.debug("ProfileProcessServlet: profile ID: " + profileId);
        if (profileId == null || profileId.equals("")) {
            logger.error("ProfileProcessServlet: Missing profile ID");
            this.setError(args, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ID_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}), request, response);
            return;
        }
        logger.info("ProfileProcessServlet: Processing " + op + " operation for request " + requestId);
        cmsReq.setRequest(req);
        CertReviewResponse data = null;
        try {
            data = processor.processRequest(cmsReq, op);
        }
        catch (ForbiddenException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
        catch (EAuthException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
        catch (EAuthzException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
        catch (BadRequestDataException e) {
            logger.error("ProfileProcessServlet: " + e.getMessage(), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
        catch (ERejectException e) {
            logger.info("ProfileProcessServlet: Request rejected: " + e.getMessage());
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REJECTED", (String[])new String[]{e.toString()}));
        }
        catch (EDeferException e) {
            logger.info("ProfileProcessServlet: Request defered: " + e.getMessage());
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEFERRED", (String[])new String[]{e.toString()}));
        }
        catch (EPropertyException e) {
            String message = CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PROPERTY_ERROR", (String[])new String[]{e.toString()});
            logger.error("ProfileProcessServlet: " + message, (Throwable)e);
            args.set("errorCode", "1");
            args.set("errorReason", message);
        }
        catch (EProfileException e) {
            logger.error("ProfileProcessServlet: " + e.getMessage(), (Throwable)e);
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
        }
        catch (EBaseException e) {
            logger.error("ProfileProcessServlet: " + e.getMessage(), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
        args.set("op", op);
        args.set("requestId", req.getRequestId().toString());
        args.set("requestStatus", req.getRequestStatus().toString());
        args.set("requestType", req.getRequestType());
        args.set("profileId", profileId);
        String errorCode = ((ArgString)args.get("errorCode")).getValue();
        if (op.equals("approve") && errorCode.equals("0") && data != null) {
            ArgList outputlist = new ArgList();
            for (ProfileOutput output : data.getOutputs()) {
                for (ProfileAttribute attr : output.getAttrs()) {
                    ArgSet outputset = new ArgSet();
                    Descriptor desc = attr.getDescriptor();
                    outputset.set("outputId", attr.getName());
                    outputset.set("outputSyntax", desc.getSyntax());
                    outputset.set("outputConstraint", desc.getConstraint());
                    outputset.set("outputName", desc.getDescription(locale));
                    outputset.set("outputVal", attr.getValue());
                    outputlist.add(outputset);
                }
            }
            args.set("outputList", outputlist);
        }
        try {
            String p12Str = req.getExtDataInString("req_issued_p12");
            if (p12Str == null) {
                logger.info("ProfileProcessServlet: No server-side keygen");
                this.outputTemplate(request, response, args);
            } else {
                logger.info("ProfileProcessServlet: Processing PKCS #12 output for server-side keygen");
                byte[] p12blob = Utils.base64decode((String)p12Str);
                HttpServletResponse p12_response = cmsReq.getHttpResp();
                p12_response.setContentType("application/x-pkcs12");
                p12_response.setContentLength(p12blob.length);
                p12_response.setHeader("Content-disposition", "attachment; filename=serverKeyGenCert.p12");
                ServletOutputStream bos = p12_response.getOutputStream();
                bos.write(p12blob);
                bos.flush();
                bos.close();
            }
        }
        catch (IOException e) {
            logger.error("ProfileProcessServlet: Unable to process PKCS #12 output: " + e.getMessage(), (Throwable)e);
            this.setError(args, e.getMessage(), request, response);
            return;
        }
    }

    private void setError(ArgSet args, String reason, HttpServletRequest request, HttpServletResponse response) throws EBaseException {
        args.set("errorCode", "1");
        args.set("errorReason", reason);
        this.outputTemplate(request, response, args);
    }
}

