/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.cms.servlet.admin.KRAConnectorProcessor;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caUpdateConnector", urlPatterns={"/admin/ca/updateConnector"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caUpdateConnector"), @WebInitParam(name="AuthMgr", value="TokenAuth"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="resourceID", value="certServer.ca.connectorInfo")})
public class UpdateConnector
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(UpdateConnector.class);
    private static final long serialVersionUID = 972871860008509849L;
    private static final String SUCCESS = "0";
    private static final String FAILED = "1";
    private static final String AUTH_FAILURE = "2";

    public void init(ServletConfig sc) throws ServletException {
        logger.debug("UpdateConnector: initializing...");
        super.init(sc);
        logger.debug("UpdateConnector: done initializing...");
    }

    public KRAConnectorInfo createConnectorInfo(HttpServletRequest httpReq) {
        KRAConnectorInfo info = new KRAConnectorInfo();
        info.setHost(httpReq.getParameter("ca.connector.KRA.host"));
        info.setPort(httpReq.getParameter("ca.connector.KRA.port"));
        info.setTimeout(httpReq.getParameter("ca.connector.KRA.timeout"));
        info.setSubsystemCert(httpReq.getParameter("ca.connector.KRA.subsystemCert"));
        info.setTransportCert(httpReq.getParameter("ca.connector.KRA.transportCert"));
        info.setTransportCertNickname(httpReq.getParameter("ca.connector.KRA.transportCertNickname"));
        info.setUri(httpReq.getParameter("ca.connector.KRA.uri"));
        info.setLocal(httpReq.getParameter("ca.connector.KRA.local"));
        info.setEnable(httpReq.getParameter("ca.connector.KRA.enable"));
        return info;
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("UpdateConnector: processing...");
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = null;
        try {
            authToken = this.authenticate(cmsReq);
            logger.debug("UpdateConnector authentication successful.");
        }
        catch (Exception e) {
            logger.error("UpdateConnector: authentication failed: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{"", e.toString()}));
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        if (authToken == null) {
            logger.error("UpdateConnector: authentication failed.");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "modify");
            logger.debug("UpdateConnector authorization successful.");
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.outputError(httpResp, "Error: Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        String status = SUCCESS;
        String error = "";
        CAEngine engine = CAEngine.getInstance();
        KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(httpReq));
        processor.setCMSEngine(engine);
        processor.init();
        KRAConnectorInfo info = this.createConnectorInfo(httpReq);
        String url = "https://" + info.getHost() + ":" + info.getPort();
        logger.info("UpdateConnector: Adding KRA connector for " + url);
        try {
            processor.addConnector(info);
        }
        catch (Exception e) {
            String message = "Unable to add KRA connector for " + url + ": " + e.getMessage();
            logger.error("UpdateConnector: " + message, (Throwable)e);
            this.sendResponse(httpResp, FAILED, message);
            return;
        }
        UGSubsystem ugSubsystem = engine.getUGSubsystem();
        String uid = "KRA-" + info.getHost() + "-" + info.getPort();
        String fullName = "KRA " + info.getHost() + " " + info.getPort();
        logger.info("UpdateConnector: Adding " + uid + " user");
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditParams = "Scope;;users+Operation;;OP_ADD+source;;UpdateConnector+Resource;;" + uid + "+fullname;;" + fullName + "+state;;1+userType;;agentType+email;;<null>+password;;<null>+phone;;<null>";
        try {
            User user = ugSubsystem.createUser(uid);
            user.setFullName(fullName);
            user.setEmail("");
            user.setPassword("");
            user.setUserType("agentType");
            user.setState(FAILED);
            user.setPhone("");
            ugSubsystem.addUser(user);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
        }
        catch (ConflictingOperationException e) {
            logger.info("UpdateConnector: User " + uid + " already exists");
        }
        catch (Exception e) {
            String message = "Unable to add " + uid + " user: " + e.getMessage();
            logger.error("UpdateConnector: " + message, (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            this.sendResponse(httpResp, FAILED, message);
            return;
        }
        String cert = info.getSubsystemCert();
        logger.info("UpdateConnector: Adding cert for " + uid + " user");
        auditParams = "Scope;;certs+Operation;;OP_ADD+source;;UpdateConnector+Resource;;" + uid + "+cert;;" + cert;
        try {
            byte[] binCert = Utils.base64decode((String)cert);
            X509CertImpl certImpl = new X509CertImpl(binCert);
            ugSubsystem.addUserCert(uid, (X509Certificate)certImpl);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
        }
        catch (ConflictingOperationException e) {
            logger.info("UpdateConnector: Certificate for " + uid + " already exists: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            String message = "Unable to add cert for " + uid + " user: " + e.getMessage();
            logger.error("UpdateConnector: " + message, (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            this.sendResponse(httpResp, FAILED, message);
            return;
        }
        String groupName = "Subsystem Group";
        logger.info("UpdateConnector: Adding " + uid + " user into " + groupName);
        auditParams = "Scope;;groups+Operation;;OP_MODIFY+source;;UpdateConnector+Resource;;" + groupName;
        try {
            Group group = ugSubsystem.getGroupFromName(groupName);
            auditParams = auditParams + "+user;;";
            Enumeration members = group.getMemberNames();
            while (members.hasMoreElements()) {
                auditParams = auditParams + (String)members.nextElement();
                if (!members.hasMoreElements()) continue;
                auditParams = auditParams + ",";
            }
            if (!group.isMember(uid)) {
                auditParams = auditParams + "," + uid;
                group.addMemberName(uid);
                ugSubsystem.modifyGroup(group);
                auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
            } else {
                logger.info("UpdateConnector: User " + uid + " already in " + groupName);
            }
        }
        catch (Exception e) {
            String message = "Unable to add " + uid + " user into " + groupName + ": " + e.getMessage();
            logger.error("UpdateConnector: " + message, (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            this.sendResponse(httpResp, FAILED, message);
            return;
        }
        this.sendResponse(httpResp, SUCCESS, null);
    }

    public void sendResponse(HttpServletResponse httpResp, String status, String error) {
        try {
            logger.debug("UpdateConnector: Sending response");
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            if (status.equals(SUCCESS)) {
                responseNode.put("Status", SUCCESS);
            } else {
                responseNode.put("Status", FAILED);
                responseNode.put("Error", error);
            }
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.error("UpdateConnector: Failed to send the output: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void setDefaultTemplates(ServletConfig sc) {
    }

    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }
}

